<?php

namespace frontend\controllers;

use Yii;
use common\models\DocumentTypes;
use common\models\DocumentTypesSearch;
use common\models\DocumentTypeRevisions;
use common\models\DocumentTypeRevisionsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\db\Query;

/**
 * DocumentTypesController implements the CRUD actions for DocumentTypes model.
 */
class DocumentTypesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all DocumentTypes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new DocumentTypesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single DocumentTypes model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $queryDocumentTypeRevisions = new Query;
        $queryDocumentTypeRevisions->select(['document_type_revisions.id as document_type_revisions_id', 'document_type_revisions.document_types_id', 'document_type_revisions.file_name', 'document_type_revisions.issue_no', 'document_type_revisions.issue_date', 'document_type_revisions.revision_no', 'document_type_revisions.revision_date', 'document_types.name as document_types_name'])  
            ->from('document_type_revisions')
            ->innerJoin('document_types', 'document_type_revisions.document_types_id = document_types.id and document_type_revisions.document_types_id = '.$id)
            ->orderBy('issue_date DESC', 'revision_date DESC')
            ->all(); 
                    
        $commandDocumentTypeRevisions = $queryDocumentTypeRevisions->createCommand();
        $documentTypeRevisions = $commandDocumentTypeRevisions->queryAll();

        return $this->render('view', [
            'model' => $this->findModel($id),
            'documentTypeRevisions' => $documentTypeRevisions,
        ]);
    }

    /**
     * Creates a new DocumentTypes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new DocumentTypes();

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing DocumentTypes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing DocumentTypes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the DocumentTypes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return DocumentTypes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = DocumentTypes::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

        /**
     * Creates a new DocumentTypeRevisions model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAdddocument($document_types_id)
    {
        $model = new DocumentTypeRevisions();
        $model->document_types_id = $document_types_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');
            $model->file_name= 'test file name';

            if ($model->save())
            {

                $total = count($_FILES['DocumentTypeRevisions']['name']); // multiple files
                $path = Yii::$app->basePath .'/web/uploads/audit_documents/'; // your upload path

                if($total >0 )
                {
                    $tmpFilePath = $_FILES['DocumentTypeRevisions']['tmp_name']['file_name']; // the temp file path
                    $fileName = $_FILES['DocumentTypeRevisions']['name']['file_name']; // the file name
                    $fileSize = $_FILES['DocumentTypeRevisions']['size']['file_name']; // the file size

                    if ($tmpFilePath != ""){
                        //Setup our new file path
                        $newFilePath = $path .'ad_'.$model->id.'_'. $fileName;
                        $newFileUrl = Yii::$app->basePath .'/web/uploads/audit_documents/' . $fileName;
                        
                        //Upload the file into the new path
                        if(move_uploaded_file($tmpFilePath, $newFilePath)) {
                            $fileId = $fileName . '1985'; // some unique key to identify the file
                            $preview[] = $newFileUrl;
                            $config[] = [
                                'key' => $fileId,
                                'caption' => $fileName,
                                'size' => $fileSize,
                                'downloadUrl' => $newFileUrl, // the url to download the file
                            ];
                        } else {
                            $errors[] = $fileName;
                        }
                    } else {
                        $errors[] = $fileName;
                    }

                }

                if($fileName)
                {
                    $model->file_name = 'ad_'.$model->id.'_'.$fileName;
                    $model->save();
                }

                return $this->redirect(['view', 'id' => $document_types_id]);
            } else {
                return $this->render('add-document', ['model' => $model,]);
            }
        } else {
            return $this->render('add-document', [
                'model' => $model,
            ]);
        }
    }

}
