<?php

namespace frontend\controllers;

use Yii;
use common\models\IafCodes;
use common\models\IafCodesSearch;
use common\models\IafCodeIndustries;
use common\models\IafCodeIndustriesSearch;
use common\models\NaceCodeIndustries;
use common\models\NaceCodeIndustriesSearch;
use common\models\IafCodeNaceCodes;
use common\models\IafCodeNaceCodesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;

/**
 * IafCodesController implements the CRUD actions for IafCodes model.
 */
class IafCodesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all IafCodes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new IafCodesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single IafCodes model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $iafCodeIndustriesSearchModel = new IafCodeIndustriesSearch();
        $iafCodeIndustriesSearchModel->iaf_codes_id = $id;

        $iafCodeIndustries = $iafCodeIndustriesSearchModel->search([]);

        $iafCodeNaceCodesSearchModel = new IafCodeNaceCodesSearch();
        $iafCodeNaceCodesSearchModel->iaf_codes_id = $id;

        $iafCodeNaceCodes = $iafCodeNaceCodesSearchModel->search([]);

        return $this->render('view', [
            'model' => $this->findModel($id),
            'iafCodeIndustries' => $iafCodeIndustries,
            'iafCodeNaceCodes' => $iafCodeNaceCodes,
        ]);
    }

    /**
     * Creates a new IafCodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new IafCodes();

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing IafCodes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing IafCodes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the IafCodes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return IafCodes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = IafCodes::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }


    /**
     * Creates a new IafCodeNaceCodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddnacecode($iaf_codes_id)
    {
        $model = new IafCodeNaceCodes();
        $model->iaf_codes_id = $iaf_codes_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->nace_code_name = $model->naceCodes->nace_code_name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                $naceCodeIndustriesSearchModel = new NaceCodeIndustriesSearch();
                $naceCodeIndustriesSearchModel->nace_codes_id = $model->naceCodes->id;

                $naceCodeIndustries = $naceCodeIndustriesSearchModel->search([]);

                foreach($naceCodeIndustries->getModels() as $naceCodeIndustry) {

                    $iafCodeIndustry = new IafCodeIndustries();

                    $iafCodeIndustry->iaf_codes_id = $iaf_codes_id;
                    $iafCodeIndustry->industries_id = $naceCodeIndustry->id;
                    $iafCodeIndustry->industry_name = $naceCodeIndustry->industry_name;
                    $iafCodeIndustry->created_by=Yii::$app->user->identity->id;
                    $iafCodeIndustry->created_on=date('Y-m-d H:i:s');
                    $iafCodeIndustry->edited_by=Yii::$app->user->identity->id;
                    $iafCodeIndustry->edited_on=date('Y-m-d H:i:s');

                    $iafCodeIndustry->save();

                }

                return $this->redirect(['view', 'id' => $iaf_codes_id]);
            }
            else
            {
                return $this->render('add-nace-code', ['model' => $model,]);
            }
        } else {
            return $this->render('add-nace-code', [
                'model' => $model,
            ]);
        }
    }

        /**
     * Creates a new IafCodeIndustries model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddindustry($iaf_codes_id)
    {
        $model = new IafCodeIndustries();
        $model->iaf_codes_id = $iaf_codes_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->industry_name = $model->industries->industry_name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $iaf_codes_id]);
            }
            else
            {
                return $this->render('add-industry', ['model' => $model,]);
            }
        } else {
            return $this->render('add-industry', [
                'model' => $model,
            ]);
        }
    }
}
