<?php

namespace frontend\controllers;

use Yii;
use common\models\NaceCodes;
use common\models\NaceCodesSearch;
use common\models\NaceCodeIndustries;
use common\models\NaceCodeIndustriesSearch;
use common\models\DeletedRecords;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\db\Query;
use yii\helpers\Html;
use yii\db\Exception;

/**
 * NaceCodesController implements the CRUD actions for NaceCodes model.
 */
class NaceCodesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all NaceCodes models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new NaceCodesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single NaceCodes model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        
        $naceCodeIndustriesSearchModel = new NaceCodeIndustriesSearch();
        $naceCodeIndustriesSearchModel->nace_codes_id = $id;

        $naceCodeIndustries = $naceCodeIndustriesSearchModel->search([]);

        return $this->render('view', [
            'model' => $this->findModel($id),
            'naceCodeIndustries' => $naceCodeIndustries
        ]);
    }

    /**
     * Creates a new NaceCodes model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new NaceCodes();

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing NaceCodes model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing NaceCodes model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        $deleted_record = $model->nace_code_name;
        try {
            $model->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "NACE Codes";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

    /**
     * Finds the NaceCodes model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return NaceCodes the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = NaceCodes::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

        /**
     * Creates a new NaceCodeIndustries model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddindustry($nace_codes_id)
    {
        $model = new NaceCodeIndustries();
        $model->nace_codes_id = $nace_codes_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->industry_name = $model->industries->industry_name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $nace_codes_id]);
            }
            else
            {
                return $this->render('add-industry', ['model' => $model,]);
            }
        } else {
            return $this->render('add-industry', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Displays a single NaceCodeIndustries model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewcustomercertificate($customer_certificates_id)
    {
        $customerCertificate = NaceCodeIndustries::findOne($customer_certificates_id);

        $auditCyclesSearchModel = new AuditCyclesSearch();
        $auditCyclesSearchModel->customer_certificates_id = $customer_certificates_id;

        $auditCycles = $auditCyclesSearchModel->search([]);

        return $this->render('view-certificate', [
            'model' => $this->findModel($customerCertificate->customers_id),
            'customerCertificate' => $customerCertificate,
            'auditCycles' => $auditCycles,
        ]);
    }
}
