<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = 'Manage Auditor Grades';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Auditor Grades</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Auditor Grades</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage Auditor Grades</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="auditor-grades-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Auditor Grade</th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $auditorGrade): ?>

                  <tr>
                    <td><?= Html::encode($auditorGrade->grade_name); ?></td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Auditor Grade</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#auditor-grades-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>