<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Certificates;
use common\models\AuditorGrades;

/* @var $this yii\web\View */
/* @var $model common\models\AuditorCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="auditor-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'auditors_id')->hiddenInput()->label(false); ?>
    <?= $form->field($model->auditors, 'full_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    <?= $form->field($model, 'certificates_id')->dropDownList(
            ArrayHelper::map(Certificates::find()->all(),'id','certification_category_name'), ['prompt'=>'Select a certificate'])?>
    
    <?php if($model->auditors->auditor_categories_id == 1 || $model->auditors->auditor_categories_id == 2) { ?>
        <?= $form->field($model, 'auditor_grades_id')->dropDownList(
                ArrayHelper::map(AuditorGrades::find()->all(),'id','grade_name'), ['prompt'=>'Select a grade'])?>
    <?php } ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
