<?php

use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Certificates;
use kartik\date\DatePicker;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model common\models\CustomerCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'id')->hiddenInput()->label(false); ?>
    
    <?php if($model->auditor_certificates_file && $model->auditor_certificates_file != 'Please add the document here') { ?>
        <?= $form->field($model, 'auditor_certificates_file')->widget(FileInput::classname(), [
        'options' => [
            'accept' => '*.*',
        ],
        'pluginOptions' => [
            'showUpload' => false, 
            'showRemove' => false,
            'showBrowse' => false,
            'showCancel' => false,
            'browseOnZoneClick' => false,
            'initialPreviewAsData' => true, 'uploadAsync' => true,
            'allowedFileExtensions' => ["jpg", "png", "gif", "pdf", "doc", "docx", "xls", "xlsx", "pdf"],
            'initialPreview' => [Url::base('') .'/uploads/auditor_certificate_documents/'.$model->auditor_certificates_file],
            'initialPreviewDownloadUrl' => [Url::base('') .'/uploads/auditor_certificate_documents/'.$model->auditor_certificates_file],
            'initialPreviewFileType' => 'pdf',
        ]
        ]); ?>

        <div class="form-group">
            <?= Html::a('Back', ['viewauditorcertificate', 'auditor_certificates_id' => $model->auditorCertificates->id], ['class' => 'btn btn-success']) ?>
        </div>

    <?php } else { ?>
        <?= $form->field($model, 'auditor_certificates_file')->widget(FileInput::classname(), [
        'options' => [
            'accept' => '*.*',
        ],
        'pluginOptions' => [
            'showUpload' => false, 
            'browseOnZoneClick' => true,
            'initialPreviewAsData' => true, 
            'uploadAsync' => true,
            'allowedFileExtensions' => ["jpg", "png", "gif", "pdf", "doc", "docx", "xls", "xlsx"],
        ]]); ?>
        
        <div class="form-group">
            <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
            <?= Html::a('Back', ['viewauditorcertificate', 'auditor_certificates_id' => $model->auditorCertificates->id], ['class' => 'btn btn-info']) ?>
        </div>

    <?php } ?>
 
    <?php ActiveForm::end(); ?>

</div>
