<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\NaceCodes;

/* @var $this yii\web\View */
/* @var $model common\models\AuditorCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="auditor-nace-code-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'auditors_id')->hiddenInput()->label(false); ?>
    <?= $form->field($model->auditors, 'full_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    <?= $form->field($model, 'nace_codes_id')->dropDownList(
        ArrayHelper::map(NaceCodes::find()->all(),'id','nace_code_name'), ['prompt'=>'Select a NACE Code'])?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
