<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;
use common\models\AuditorCategories;

/* @var $this yii\web\View */
/* @var $model common\models\Customers */
/* @var $form yii\widgets\ActiveForm */

?>

<div class="auditors-form">
    <?php $form = ActiveForm::begin([
        'options' => [
            'class' => 'needs-validation',
            'novalidate' => true,
            ]
    ]); ?>

    <?= $form->field($model, 'auditor_categories_id')->dropDownList(
            ArrayHelper::map(AuditorCategories::find()->all(),'id','category_name'), ['prompt'=>'Select an auditor category'])?> 

    <?= $form->field($model, 'full_name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'email_address')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'postal_address')->textArea(['maxlength' => true, 'rows' => 3]) ?>

    <?= $form->field($model, 'contact_phone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'joined_date')->widget(
            DatePicker::className(),[
                'name' => 'joined_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <?= $form->field($model, 'birth_date')->widget(
            DatePicker::className(),[
                'name' => 'birth_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <?= $form->field($model, 'gender')->dropDownList($model->getGenderLabels(), ['prompt' => 'Select the gender']) ?>

    <?= $form->field($model, 'active')->checkBox() ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('<i class="far fa-list-alt"></i> Auditors', ['index'], ['class' => 'btn btn-info']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>
    

