<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\Auditors */

$this->title = $model->full_name.' - '. $auditorCertificate->certificates->certification_category_name;
$this->params['breadcrumbs'][] = ['label' => 'Auditors Certificate', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Resource Personals', ['index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Auditor Certificates', ['view', 'id' => $model->id]) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <?php if (Yii::$app->session->hasFlash('uploadSuccess')){ ?>
                  <div class="alert alert-success">
                      <!-- flash message -->
                      The file uploaded successfully.
                  </div>
                <?php } ?>
              </div>
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this auditor certificate?',
                            'method' => 'post',
                        ],
                    ]) ?>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Documents', ['uploaddocuments', 'auditor_certificates_id' => $auditorCertificate->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Auditor Certificates', ['view', 'id' => $model->id], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $auditorCertificate->getAttributeLabel('auditors_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditorCertificate->auditors_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $auditorCertificate->getAttributeLabel('certification_category_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditorCertificate->certification_category_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $auditorCertificate->auditorGrades->getAttributeLabel('grade_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $auditorCertificate->auditorGrades->grade_name ?>
                        </dd>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->
              <div class="card-header">
                <h2 class="card-title text-primary">Auditor Certificate Documents</h2>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="documents-table" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>File</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($auditorCertificatesFiles->getModels() as $auditorCertificatesFile): ?>

                        <tr>
                        <td><?= Html::encode($auditorCertificatesFile->auditor_certificates_file); ?></td>
                        <td>
                            <?= Html::a('<i class="fa fa-paperclip"></i>', ['auditors/adddocuments','auditor_certificates_files_id' => $auditorCertificatesFile->id], ['class' => 'btn btn-warning']) ?>
                            <button class="btn btn-danger" id="btnDelete<?= Html::encode($auditorCertificatesFile->id)?>" onclick="deleteAuditorCertificateDocument(<?= Html::encode($auditorCertificatesFile->id)?>,<?= Html::encode($auditorCertificatesFile->auditor_certificates_id)?>);" ><i class="far fa-trash-alt"></i></button>
                        </td>
                        
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                  <tfoot>
                    <tr>
                        <th>File</th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>
              
              </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#documents-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function deleteAuditorCertificateDocument(id, auditor_certificates_id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this document?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=auditors/deletedocument&auditor_certificates_files_id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected document as it is in use.');
              }
              else {
                window.location.replace("index.php?r=auditors/viewauditorcertificate&auditor_certificates_id="+auditor_certificates_id);
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }

</script>