<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);


/* @var $this yii\web\View */
/* @var $model common\models\Auditors */

$this->title = $model->full_name;
$this->params['breadcrumbs'][] = ['label' => 'Auditors', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Resource Personals', ['index']) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <button class="btn btn-danger" id="btnDelete" onclick="deleteAuditor(<?= Html::encode($model->id)?>);" ><i class="far fa-trash-alt"></i> Delete</button>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Certificate', ['addcertificate', 'auditors_id' => $model->id], ['class' => 'btn btn-success']) ?>
                    <?php if($model->auditor_categories_id == 1 || $model->auditor_categories_id == 2 || $model->auditor_categories_id == 3) { ?>
                        <?= Html::a('<i class="fas fa-plus"></i> Add NACE Code', ['addnacecode', 'auditors_id' => $model->id], ['class' => 'btn btn-success']) ?>
                    <?php } else { ?>
                        <?= Html::a('<i class="fas fa-plus"></i> Add Certificate Category', ['addcertificatecategory', 'auditors_id' => $model->id], ['class' => 'btn btn-success']) ?>
                    <?php } ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Resource Personals', ['index'], ['class' => 'btn btn-info']) ?>
                </p>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('auditor_categories_id') ?>
                        </dt>
                        <dd class="col-sm-9">
                        <?= $model->auditorCategories->category_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('full_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->full_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('contact_phone') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->contact_phone ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('email_address') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->email_address ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('postal_address') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->postal_address ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('joined_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->joined_date ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('birth_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->birth_date ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('gender') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->gender ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('active') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->active == 1 ? 'Yes' : 'No' ?>
                        </dd>
                    </dl>
                </div>
            </div>
            <!-- /.card-body -->
            <div class="card-header">
                <h3 class="card-title">Certificates</h3>
            </div>
            <div class="card-body">
                <table id="certificates-table" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th>Certificate</th>
                        <?php if($model->auditor_categories_id == 1 || $model->auditor_categories_id == 2) { ?>
                            <th>Auditor Grade</th>
                        <?php } ?>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php foreach($auditorCertificates->getModels() as $auditorCertificate): ?>

                            <tr>
                            <td><?= Html::encode($auditorCertificate->certification_category_name); ?></td>
                            <?php if($model->auditor_categories_id == 1 || $model->auditor_categories_id == 2) { ?>
                                <td><?= Html::encode($auditorCertificate->auditorGrades->grade_name); ?></td>
                            <?php } ?>
                            <td>
                                <?= Html::a('<i class="fa fa-fw fa-paper-plane"></i>', ['auditors/viewauditorcertificate','auditor_certificates_id' => $auditorCertificate->id], ['class' => 'btn btn-primary']) ?>
                                <?= Html::a('<i class="far fa-trash-alt"></i>', ['/client-locations/delete','id' => $auditorCertificate->id], ['class' => 'btn btn-danger']) ?>
                            </td>
                            </tr>

                        <?php endforeach ?>
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>Certificate</th>
                        <?php if($model->auditor_categories_id == 1 || $model->auditor_categories_id == 2) { ?>
                            <th>Auditor Grade</th>
                        <?php } ?>
                        <th></th>
                    </tr>
                    </tfoot>
                </table>
            </div>
            <!-- /.card-body -->

            <?php if($model->auditor_categories_id == 1 || $model->auditor_categories_id == 2 || $model->auditor_categories_id == 3) { ?>
                <div class="card-header">
                    <h3 class="card-title">NACE Codes</h3>
                </div>
                <div class="card-body">
                    <table id="nace-codes-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>NACE Code</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php foreach($auditorNaceCodes->getModels() as $auditorNaceCode): ?>

                                <tr>
                                <td><?= Html::encode($auditorNaceCode->nace_code_name); ?></td>
                                <td>
                                    <?= Html::a('<i class="far fa-trash-alt"></i>', ['/client-locations/delete','id' => $auditorNaceCode->id], ['class' => 'btn btn-danger']) ?>
                                </td>
                                </tr>

                            <?php endforeach ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <th>NACE Code</th>
                            <th></th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            <?php } else { ?>
                <div class="card-header">
                    <h3 class="card-title">Certificate Categories</h3>
                </div>
                <div class="card-body">
                    <table id="certificate-categories-table" class="table table-bordered table-striped">
                        <thead>
                        <tr>
                            <th>Certificate Category</th>
                            <th></th>
                        </tr>
                        </thead>
                        <tbody>
                            <?php foreach($auditorCertificateCategories->getModels() as $auditorCertificateCategory): ?>

                                <tr>
                                <td><?= Html::encode($auditorCertificateCategory->category_name); ?></td>
                                <td>
                                    <?= Html::a('<i class="far fa-trash-alt"></i>', ['/client-locations/delete','id' => $auditorCertificateCategory->id], ['class' => 'btn btn-danger']) ?>
                                </td>
                                </tr>

                            <?php endforeach ?>
                        </tbody>
                        <tfoot>
                        <tr>
                            <th>Certificate Category</th>
                            <th></th>
                        </tr>
                        </tfoot>
                    </table>
                </div>
            <?php } ?>
            
            </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  function deleteAuditor(id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this resource person?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=auditors/delete&id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected resource person as it is in use.');
              }
              else {
                window.location.replace("index.php?r=auditors");
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
</script>

