<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\Certificates */

$this->title = $model->certification_category_name . '-' . $model->reference_standard;
$this->params['breadcrumbs'][] = ['label' => 'Certificates', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Certificates', ['index']) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Certificates', ['index'], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this certificate?',
                            'method' => 'post',
                        ],
                    ]) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('certificate_types_id') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->certificateTypes->type_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('certification_category_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->certification_category_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('reference_standard') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->reference_standard ?>
                        </dd>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->

              <div class="card-body">

                <table id="certificates-table" class="table table-bordered table-striped">
                <thead>
                  <tr>
                    <th>Customer</th>
                    <th>Accredited</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($customerCertificates as $customerCertificate): ?>

                  <tr>
                    <td><?= Html::encode($customerCertificate['customers_name']); ?></td>
                    <td>
                            <input type="checkbox" style="margin-left:5px;" name="accredited<?=$customerCertificate['customer_certificates_id']?>" id="accredited<?=$customerCertificate['customer_certificates_id']?>" 
                             <?= ($customerCertificate['accreditation']==1 ? 'checked' : '');?>
                            >
                        </td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/customers/view','id' => $customerCertificate['customers_id']], ['class' => 'btn btn-info']) ?>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Customer</th>
                    <th>Accredited</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>
