<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Cycles;
use common\models\Phases;
use common\models\DocumentTypes;

/* @var $this yii\web\View */
/* @var $model common\models\DefaultDocuments */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'audit_phases_id')->hiddenInput()->label(false); ?>
    
    <?= $form->field($model->auditPhases->auditCycles->cycles, 'cycle_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>
    
    <?= $form->field($model->auditPhases, 'phases_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    <?= $form->field($model, 'document_types_id')->dropDownList(
            ArrayHelper::map(DocumentTypes::find()->all(),'id','name'), ['prompt'=>'Select a document'])?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('<i class="far fa-list-alt"></i> Audit Phases', ['viewphase','audit_phases_id' => $model->audit_phases_id], ['class' => 'btn btn-info']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
