<?php

use yii\helpers\Url;
use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Certificates;
use kartik\date\DatePicker;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model common\models\CustomerCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'id')->hiddenInput()->label(false); ?>
    
    <?php if($model->audit_documents_file && $model->audit_documents_file != 'Please add the document here') { ?>
        <?= $form->field($model, 'audit_documents_file')->widget(FileInput::classname(), [
        'options' => [
            'accept' => '*.*',
        ],
        'pluginOptions' => [
            'showUpload' => false, 
            'showRemove' => false,
            'showBrowse' => false,
            'showCancel' => false,
            'browseOnZoneClick' => true,
            'initialPreviewAsData' => true, 'uploadAsync' => true,
            'allowedFileExtensions' => ["jpg", "png", "gif", "pdf", "doc", "docx", "xls", "xlsx", "pdf"],
            'initialPreview' => [Url::base('') .'/uploads/customer_documents/'.$model->audit_documents_file],
            'initialPreviewDownloadUrl' => [Url::base('') .'/uploads/customer_documents/'.$model->audit_documents_file],
            'initialPreviewFileType' => 'pdf',
        ]
        ]); ?>
        
        <div class="form-group">
            <?= Html::a('Back', ['viewdocuments', 'audit_documents_id' => $model->auditDocuments->id], ['class' => 'btn btn-success']) ?>
        </div>

    <?php } else { ?>
        <?= $form->field($model, 'audit_documents_file')->widget(FileInput::classname(), [
        'options' => [
            'accept' => '*.*',
        ],
        'pluginOptions' => [
            'showUpload' => false, 
            'browseOnZoneClick' => true,
            'initialPreviewAsData' => true, 
            'uploadAsync' => true,
            'allowedFileExtensions' => ["jpg", "png", "gif", "pdf", "doc", "docx", "xls", "xlsx"],
        ]]); ?>

        <div class="form-group">
            <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
            <?= Html::a('Back', ['viewdocuments', 'audit_documents_id' => $model->auditDocuments->id], ['class' => 'btn btn-info']) ?>
        </div>

    <?php } ?>

    <?php ActiveForm::end(); ?>

</div>
