<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;

use common\models\Phases;
use common\models\AuditStatus;

/* @var $this yii\web\View */
/* @var $model common\models\CustomerCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'audit_cycles_id')->hiddenInput()->label(false); ?>
    <?= $form->field($model->auditCycles->cycles, 'cycle_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    
    <?php if($model->phases_id > 0) { ?>
        <?= $form->field($model, 'phases_id')->hiddenInput()->label(false); ?>
        <?= $form->field($model->phases, 'name')->textInput(['maxlength' => true,'readonly'=> true]) ?>
    <?php } else { ?>
        <?= $form->field($model, 'phases_id')->dropDownList(
            ArrayHelper::map(Phases::find()->all(),'id','name'), ['prompt'=>'Select a phase'])?>
    <?php } ?>

    <?= $form->field($model, 'calling_date')->widget(
            DatePicker::className(),[
                'name' => 'calling_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <?= $form->field($model, 'schedule_date')->widget(
            DatePicker::className(),[
                'name' => 'schedule_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <?= $form->field($model, 'actual_start_date')->widget(
            DatePicker::className(),[
                'name' => 'actual_start_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <?= $form->field($model, 'actual_end_date')->widget(
            DatePicker::className(),[
                'name' => 'actual_end_date',
                'type' => DatePicker::TYPE_COMPONENT_APPEND,
                'pluginOptions' => [
                    'autoclose'=>true,
                    'format' => 'yyyy-mm-dd'
                ]
            ]
        );?>

    <?= $form->field($model, 'audit_status_id')->dropDownList(
            ArrayHelper::map(AuditStatus::find()->all(),'id','status_name'), ['prompt'=>'Select the status'])?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('<i class="far fa-list-alt"></i> Audit Phases', ['viewcycle','audit_cycles_id' => $model->audit_cycles_id], ['class' => 'btn btn-info']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
