<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use kartik\date\DatePicker;

/* @var $this yii\web\View */
/* @var $model common\models\Customers */
/* @var $form yii\widgets\ActiveForm */

?>

<div class="customers-form">
    <?php $form = ActiveForm::begin([
        'options' => [
            'class' => 'needs-validation',
            'novalidate' => true,
            ]
    ]); ?>

    <?= $form->field($model, 'name')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'company_email')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'general_phone')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'head_office_address')->textArea(['maxlength' => true, 'rows' => 3]) ?>

    <?= $form->field($model, 'site_address')->textArea(['maxlength' => true, 'rows' => 3]) ?>

    <?= $form->field($model, 'joined_date')->widget(
        DatePicker::className(),[
            'name' => 'joined_date',
            'type' => DatePicker::TYPE_COMPONENT_APPEND,
            'pluginOptions' => [
                'autoclose'=>true,
                'format' => 'yyyy-mm-dd'
            ]
        ]
    );?>

    <h5>Contact Persons:</h5>

    <div class="row">
        <div class="col-md-6">
            <?= $form->field($model, 'first_contact')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'first_contact_designation')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'first_contact_email')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'first_contact_phone_1')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'first_contact_phone_2')->textInput(['maxlength' => true]) ?>

        </div>

        <div class="col-md-6">
            <?= $form->field($model, 'second_contact')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'second_contact_designation')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'second_contact_email')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'second_contact_phone_1')->textInput(['maxlength' => true]) ?>

            <?= $form->field($model, 'second_contact_phone_2')->textInput(['maxlength' => true]) ?>

        </div>

    </div>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('<i class="far fa-list-alt"></i> Customers', ['index'], ['class' => 'btn btn-info']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>
    

