<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = 'Manage Customers';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Customers</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Customers</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New Customer', ['/customers/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage customers</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="customers-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Customer</th>
                    <th>Email</th>
                    <th>General Phone</th>
                    <th>Address</th>
                    <th>Contact Person</th>
                    <th>Phone</th>
                    <th>Joined Date</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $customer): ?>

                  <tr>
                    <td><?= Html::encode($customer->name); ?></td>
                    <td><?= Html::encode($customer->company_email); ?></td>
                    <td><?= Html::encode($customer->general_phone); ?></td>
                    <td><?= Html::encode($customer->head_office_address); ?></td>
                    <td><?= Html::encode($customer->first_contact); ?></td>
                    <td><?= Html::encode($customer->first_contact_phone_1); ?></td>
                    <td><?= Html::encode($customer->joined_date); ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/customers/view','id' => $customer->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/customers/update','id' => $customer->id], ['class' => 'btn btn-warning']) ?>
                      <button class="btn btn-danger" id="btnDelete<?= Html::encode($customer->id)?>" onclick="deleteCustomer(<?= Html::encode($customer->id)?>);" ><i class="far fa-trash-alt"></i></button>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Customer</th>
                    <th>Email</th>
                    <th>General Phone</th>
                    <th>Address</th>
                    <th>Contact Person</th>
                    <th>Phone</th>
                    <th>Joined Date</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#customers-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function deleteCustomer(id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this customer?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=customers/delete&id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected customer as it is in use.');
              }
              else {
                window.location.replace("index.php?r=customers");
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
</script>