<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;
use kartik\dialog\Dialog;

echo Dialog::widget([
    'libName' => 'krajeeDialog',
    'options' => ['draggable' => true, 'closable' => true], 
  ]);

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = $model->name.' - '. $customerCertificate->certificates->certification_category_name;
$this->params['breadcrumbs'][] = ['label' => 'Customers Certificate', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Customers', ['index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Customer Certificates', ['view', 'id' => $model->id]) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['updatecustomercertificate', 'customer_certificates_id' => $customerCertificate->id], ['class' => 'btn btn-warning']) ?>
                    <button class="btn btn-danger" id="btnDeleteCustomerCertificate" onclick="btnDeleteCustomerCertificate(<?= Html::encode($customerCertificate->id)?>,<?= Html::encode($model->id)?>);" ><i class="far fa-trash-alt"></i>  Delete</button>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Audit Cycle', ['addcycle', 'customer_certificates_id' => $customerCertificate->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Customers', ['index'], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $customerCertificate->certificates->getAttributeLabel('certification_category_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $customerCertificate->certificates->certification_category_name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $customerCertificate->certificates->getAttributeLabel('reference_standard') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $customerCertificate->certificates->reference_standard ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $customerCertificate->getAttributeLabel('accreditation') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $customerCertificate->accreditation == 1 ? 'Yes' : 'No' ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $customerCertificate->getAttributeLabel('multisite') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $customerCertificate->multisite == 1 ? 'Yes' : 'No' ?>
                        </dd>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="cycles-table" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th>Audit Cycle</th>
                        <th>Filing Name</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($auditCycles->getModels() as $auditCycle): ?>

                        <tr>
                        <td><?= Html::encode($auditCycle->cycles->cycle_name); ?></td>
                        <td><?= Html::encode($auditCycle->filing_name); ?></td>
                        <td>
                            <?= Html::a('<i class="fa fa-fw fa-paper-plane"></i>', ['customers/viewcycle','audit_cycles_id' => $auditCycle->id], ['class' => 'btn btn-primary']) ?>
                            <?= Html::a('<i class="far fa-trash-alt"></i>', ['/client-locations/delete','id' => $auditCycle->id], ['class' => 'btn btn-danger']) ?>
                            
                        </td>
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>Audit Cycle</th>
                        <th>Filing Name</th>
                        <th></th>
                    </tr>
                    </tfoot>
                    </table>`
              </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  function btnDeleteCustomerCertificate(id, customers_id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this customer certificate?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=customers/deletecustomercertificate&customer_certificates_id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected customer certificate as it is in use.');
              }
              else {
                window.location.replace("index.php?r=customers/view&id="+customers_id);
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
  </script>