<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\DeletedRecordsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Deleted Records';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="deleted-records-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Deleted Records', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'area_name',
            'deleted_record',
            'created_on',
            'created_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, DeletedRecords $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
