<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\DocumentActionsSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Document Actions';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="document-actions-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Document Actions', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'user_id',
            'audit_documents_id',
            'audit_document_history_id',
            'action_date',
            //'created_on',
            //'created_by',
            //'edited_on',
            //'edited_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, DocumentActions $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
