<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\IafCodeIndustriesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Iaf Code Industries';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="iaf-code-industries-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Iaf Code Industries', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'iaf_codes_id',
            'industries_id',
            'industry_name',
            'created_on',
            //'created_by',
            //'edited_on',
            //'edited_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, IafCodeIndustries $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
