<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = $model->iaf_code;
$this->params['breadcrumbs'][] = ['label' => 'IAF Codes', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage IAF Codes', ['index']) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this IAF code?',
                            'method' => 'post',
                        ],
                    ]) ?>

                    <?= Html::a('<i class="far fa-list-alt"></i> Manage IAF Codes', ['index'], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('iaf_code') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->iaf_code ?>
                        </dd>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->
              <div class="card-header">
                <?= Html::a('<i class="fas fa-plus"></i> Add NACE Code', ['addnacecode', 'iaf_codes_id' => $model->id], ['class' => 'btn btn-success']) ?>
              </div>
              <div class="card-body">
                <table id="nace-codes-table" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th>NACE Code</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($iafCodeNaceCodes->getModels() as $iafCodeNaceCode): ?>

                        <tr>
                        <td><?= Html::encode($iafCodeNaceCode->nace_code_name); ?></td>
                        <td>
                            <?= Html::a('<i class="far fa-trash-alt"></i>', ['/iaf-codes/deletenacecode','id' => $iafCodeNaceCode->id], ['class' => 'btn btn-danger']) ?>
                        </td>
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>NACE Code</th>
                        <th></th>
                    </tr>
                    </tfoot>
                    </table>`
              </div>

              <div class="card-header">
                <?= Html::a('<i class="fas fa-plus"></i> Add Industry', ['addindustry', 'iaf_codes_id' => $model->id], ['class' => 'btn btn-success']) ?>
              </div>
              <div class="card-body">
                <table id="industries-table" class="table table-bordered table-striped">
                    <thead>
                    <tr>
                        <th>Industry</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($iafCodeIndustries->getModels() as $iafCodeIndustry): ?>

                        <tr>
                        <td><?= Html::encode($iafCodeIndustry->industry_name); ?></td>
                        <td>
                            <?= Html::a('<i class="far fa-trash-alt"></i>', ['/iaf-codes/deleteindustry','id' => $iafCodeIndustry->id], ['class' => 'btn btn-danger']) ?>
                        </td>
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                    <tfoot>
                    <tr>
                        <th>Industry</th>
                        <th></th>
                    </tr>
                    </tfoot>
                    </table>`
              </div>
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>
