<?php

/* @var $this \yii\web\View */
/* @var $content string */

use yii\helpers\Html;
use yii\widgets\Breadcrumbs;
use frontend\assets\AppAsset;
use common\widgets\Alert;

AppAsset::register($this);
?>
<?php $this->beginPage() ?>
<!DOCTYPE html>
<html lang="<?= Yii::$app->language ?>">
<head>
    <meta charset="<?= Yii::$app->charset ?>">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php $this->registerCsrfMetaTags() ?>
    <title><?= Html::encode($this->title) ?></title>
    <?php $this->head() ?>
</head>
<body class="hold-transition sidebar-mini layout-fixed">
<?php $this->beginBody() ?>

<div class="wrapper">
  <!-- Navbar -->
  <nav class="main-header navbar navbar-expand navbar-white navbar-light">
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item">
        <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a>
      </li>
      <li class="nav-item d-none d-sm-inline-block">
        <?= Html::a('Go to Dashboard', ['site/index'],['class' => 'nav-link']) ?>
      </li>
    </ul>

    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
      <!-- Messages Dropdown Menu -->

      <!-- Notifications Dropdown Menu -->

      <!-- User Dropdown Menu -->
      <li class="nav-item dropdown">
        <a class="nav-link" data-toggle="dropdown" href="#">
          <?php
            if (Yii::$app->user->isGuest == false) 
            {
            ?>
            <?= Html::tag('span', Html::encode(Yii::$app->user->identity->first_name. ' '.Yii::$app->user->identity->last_name)) ?>
            <?php
            } else {
              ?>
                <?= Html::tag('span', Html::encode('Admin User')) ?>
              <?php
            } 
          ?>
        </a>
        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
          <!-- Profile Image -->
          <div class="card card-primary card-outline">
            <div class="card-body box-profile">
              <div class="text-center">
                <img class="profile-user-img img-fluid img-circle"
                      src="dist/img/avatar5.png"
                      alt="User profile picture">
              </div>

              <h3 class="profile-username text-center">
                <?php
                if (Yii::$app->user->isGuest == false) 
                {
                ?>
                <?= Html::tag('span', Html::encode(Yii::$app->user->identity->first_name.' '.Yii::$app->user->identity->last_name)) ?>
                <?php
                } else {
                ?>
                  <?= Html::tag('span', Html::encode('Admin User')) ?>
                <?php
                } 
                ?>
              </h3>
              <a href="#" class="btn btn-primary btn-block"><b>Profile</b></a>
              <?= Html::a('Sign out',['/site/logout'], [
                  'data'=>[
                      'method' => 'post', ] ,'class' => 'btn btn-default btn-block', 
                    ]
              ) ?>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
      </li>

    </ul>
  </nav>
  <!-- /.navbar -->

  <!-- Main Sidebar Container -->
  <aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="index.php" class="brand-link">
      <img src="dist/img/indexpo_logo.png" alt="IndExpo Logo" class="brand-image img-circle elevation-3"
           style="opacity: .8">
      <span class="brand-text font-weight-light">Ind-Expo Docs</span>
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
      <!-- Sidebar user panel (optional) -->
      <div class="user-panel mt-3 pb-3 mb-3 d-flex">
        <div class="image">
          <img src="dist/img/avatar5.png" class="img-circle elevation-2" alt="User Image">
        </div>
        <div class="info">
          <a href="#" class="d-block">
            <?php
              if (Yii::$app->user->isGuest == false) 
              {
            ?>
              <?= Html::tag('span', Html::encode(Yii::$app->user->identity->first_name.' '.Yii::$app->user->identity->last_name)) ?>
            <?php
              } else {
                ?>
                  <?= Html::tag('span', Html::encode('Admin User')) ?>
                <?php
                } 
            ?>
          </a>
        </div>
      </div>

      <!-- Sidebar Menu -->
      <nav class="mt-2">
        <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
          <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->

          <li class="nav-item">
            <a href="index.php" class="nav-link active">
              <i class="nav-icon fas fa-tachometer-alt"></i>
              <p>
                Dashboard
              </p>
            </a>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fa fa-search"></i> <p>Global Search</p>', ['/searches'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fa fa-check"></i> <p>Approve Documents</p>', ['/audit-documents'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fa fa-industry"></i> <p>Industries</p>', ['/industries'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fa fa-sticky-note"></i> <p>NACE Codes/ Category</p>', ['/nace-codes'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fa fa-sticky-note"></i> <p>IAF Codes</p>', ['/iaf-codes'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item has-treeview">
            <a href="#" class="nav-link">
              <i class="nav-icon far fa-file-alt"></i>
              <p>
                Certificate Management
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Certificate Types</p>', ['/certificate-types'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Certificate Categories</p>', ['/certificate-categories'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Certificate Status</p>', ['/certificate-status'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Certificates</p>', ['/certificates'], ['class' => 'nav-link']) ?>
              </li>
            </ul>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fas fa-tasks"></i> <p>Audit Status</p>', ['/audit-status'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fas fa-tasks"></i> <p>Default Audit Cycles</p>', ['/cycles'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fas fa-tasks"></i> <p>Default Audit Phases</p>', ['/phases'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item has-treeview">
            <a href="#" class="nav-link">
              <i class="nav-icon fa fa-sticky-note"></i>
              <p>
                Document Management
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Document Types</p>', ['/document-types'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Default Documents</p>', ['/default-documents'], ['class' => 'nav-link']) ?>
              </li>
            </ul>
          </li>
          <li class="nav-item">
            <?= Html::a('<i class="nav-icon fas fa-users"></i> <p>Customers</p>', ['/customers'], ['class' => 'nav-link']) ?>
          </li>
          <li class="nav-item has-treeview">
            <a href="#" class="nav-link">
              <i class="nav-icon fas fa-users"></i>
              <p>
                Resources Management
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Auditor Categories</p>', ['/auditor-categories'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Auditor Grades</p>', ['/auditor-grades'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Resource Personals List</p>', ['/auditors'], ['class' => 'nav-link']) ?>
              </li>
            </ul>
          </li>
          <li class="nav-item has-treeview">
            <a href="#" class="nav-link">
              <i class="nav-icon far fa-user"></i>
              <p>
                User Management
                <i class="right fas fa-angle-left"></i>
              </p>
            </a>
            <ul class="nav nav-treeview">
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>User Roles</p>', ['/user-roles'], ['class' => 'nav-link']) ?>
              </li>
              <li class="nav-item">
                <?= Html::a('<i class="far fa-circle nav-icon"></i> <p>Users List</p>', ['/user'], ['class' => 'nav-link']) ?>
              </li>
            </ul>
          </li>
        </ul>
      </nav>
      <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
  </aside>

  <!-- Content Wrapper. Contains page content -->
  <div class="content-wrapper">
    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
        <?= $content ?>
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
  </div>
  <!-- /.content-wrapper -->
  <footer class="main-footer">
    <strong>Copyright &copy; <script>document.write(new Date().getFullYear())</script> <a href="https://indexpo.lk/">Ind-Expo Certification Limited</a>.</strong>
    All rights reserved.
    <div class="float-right d-none d-sm-inline-block">
      Developed by <b><a href="https://litsolutions.lk/" target="_blank">Lit Solutions</a></b>
    </div>
  </footer>

  <!-- Control Sidebar -->
  <aside class="control-sidebar control-sidebar-dark">
    <!-- Control sidebar content goes here -->
  </aside>
  <!-- /.control-sidebar -->
</div>

<?php $this->endBody() ?>
</body>
</html>

<!-- Resolve conflict in jQuery UI tooltip with Bootstrap tooltip -->
<script>
  $.widget.bridge('uibutton', $.ui.button)
</script>

<?php $this->endPage() ?>
