<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = 'Manage NACE Codes/ Category';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage NACE Codes/ Category</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage NACE Codes/ Category</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New NACE Code/ Category', ['/nace-codes/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage NACE Codes/ Category</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="nace-codes-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>NACE Code/ Category</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $naceCode): ?>

                  <tr>
                    <td><?= Html::encode($naceCode->nace_code_name); ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/nace-codes/view','id' => $naceCode->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/nace-codes/update','id' => $naceCode->id], ['class' => 'btn btn-warning']) ?>
                      <button class="btn btn-danger" id="btnDelete<?= Html::encode($naceCode->id)?>" onclick="deleteNaceCode(<?= Html::encode($naceCode->id)?>);" ><i class="far fa-trash-alt"></i></button>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>NACE Code/ Category</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#nace-codes-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function deleteNaceCode(id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this NACE Code/ Category?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=nace-codes/delete&id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected NACE Code/ Category as it is in use.');
              }
              else {
                window.location.replace("index.php?r=nace-codes");
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
</script>