<?php
use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Certificates;


/* @var $this yii\web\View */

$this->title = "Ind-Expo Document Library";

if (isset(Yii::$app->user->identity->id))
{

?>
<!-- Content Header (Page header) -->
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0 text-dark">Dashboard</h1>
            </div><!-- /.col -->
            <div class="col-sm-6">
            </div><!-- /.col -->
        </div><!-- /.row -->
    </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<!-- Small boxes (Stat box) -->
<div class="row">
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-success">
            <div class="inner">
            <h3><?= Html::encode($auditsCount); ?></h3>

            <p>Audits</p>
            </div>
            <div class="icon">
            <i class="ion ion-flag"></i>
            </div>
            <?= Html::a('More info <i class="fas fa-arrow-circle-right"></i> ', ['/searches'], ['class' => 'small-box-footer']) ?>
        </div>
    </div>
    <!-- ./col -->
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-warning">
            <div class="inner">
            <h3><?= Html::encode($clientsCount); ?></h3>
            <p>Customers</p>
            </div>
            <div class="icon">
            <i class="ion ion-ios-home-outline"></i>
            </div>
            <?= Html::a('More info <i class="fas fa-arrow-circle-right"></i> ', ['/customers'], ['class' => 'small-box-footer']) ?>
        </div>
    </div>
    <!-- ./col -->
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-danger">
            <div class="inner">
            <h3><?= Html::encode($auditorsCount); ?></h3>

            <p>Auditors</p>
            </div>
            <div class="icon">
            <i class="ion ion-person-stalker"></i>
            </div>
            <?= Html::a('More info <i class="fas fa-arrow-circle-right"></i> ', ['/auditors'], ['class' => 'small-box-footer']) ?>
        </div>
    </div>
    <!-- ./col -->
    <div class="col-lg-3 col-6">
        <!-- small box -->
        <div class="small-box bg-primary">
            <div class="inner">
            <h3><?= Html::encode($auditAreaCount); ?></h3>

            <p>Certificates</p>
            </div>
            <div class="icon">
            <i class="ion ion-pinpoint"></i>
            </div>
            <?= Html::a('More info <i class="fas fa-arrow-circle-right"></i> ', ['/certificates'], ['class' => 'small-box-footer']) ?>
        </div>
    </div>
    <!-- ./col -->
</div>
<!-- /.row -->
<?php $form = ActiveForm::begin(); ?>

<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header border-transparent">
                
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-sm-3">
                        <div class="input-group">
                            <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="far fa-calendar-alt"></i>
                            </span>
                            </div>
                            <input type="text" class="form-control float-right" id="auditdaterange">
                        </div>
                        <!-- /.input group -->
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-6">
                        <h3 class="card-title mb-4"> Completed Audits</h3>
                        <div class="card-body" id="completed-audits"></div>
                    </div>
                    <div class="col-sm-6">
                        <h3 class="card-title mb-4"> Not Completed Audits</h3>
                        <div class="card-body" id="not-completed-audits"></div>
                    </div>
                </div>

            </div>
            <!-- /.card-body -->
        </div>
    </div>
</div>

<div class="row">
    <!-- Left col -->
    <section class="col-lg-12 connectedSortable">
        <!-- Custom tabs (Charts with tabs)-->
        <div class="card">
            <div class="card-header">
                <h3 class="card-title">
                    <i class="far fa-calendar-alt mr-1"></i>
                    Audit Summary by Month
                </h3>

            </div><!-- /.card-header -->
            <div class="card-body">
                <div class="row mb-3">
                    <div class="col-sm-3">
                        <div class="input-group">
                            <div class="input-group-prepend">
                            <span class="input-group-text">
                                <i class="far fa-calendar-alt"></i>
                            </span>
                            </div>
                            <input type="text" class="form-control float-right" id="auditsumdaterange">
                        </div>
                        <!-- /.input group -->
                    </div>
                    <div class="col-sm-2">
                        <?= $form->field($modelCertificates, 'id')->dropDownList(
                            ArrayHelper::map(Certificates::find()->all(),'id','certification_category_name'), ['prompt'=>'Select a certificate'])->label(false)?>
                    </div>
                </div>

                <div class="position-relative mb-4">
                  <canvas id="certificate-counts-chart" height="400"></canvas>
                </div>
            </div><!-- /.card-body -->
        </div>
        <!-- /.card -->
    </section>
    <!-- /.Left col -->
    <!-- right col -->
</div>

<!-- /.row (main row) -->

<?php ActiveForm::end(); ?>

<?php
}
else
{
  Yii::$app->getResponse()->redirect(\Yii::$app->getUser()->loginUrl);
}

?>

<script>

$(function () {
    var today = new Date();
    var firstOfCurrentMonth = new Date(today.getFullYear(), today.getMonth(), 1);
    
    var endDate = new Date();
    endDate.setMonth(endDate.getMonth() + 1);
    endDate = new Date(endDate.getFullYear(), endDate.getMonth()+1, 0);

    var firstOfSixMonthBack = new Date();
    firstOfSixMonthBack = new Date(firstOfSixMonthBack.getFullYear(), endDate.getMonth()-7, 1);

    var lastOfPrevMonth = new Date();
    lastOfPrevMonth = new Date(lastOfPrevMonth.getFullYear(), endDate.getMonth()+2, 0);

    GetAudits(firstOfCurrentMonth.toISOString().split('T')[0], endDate.toISOString().split('T')[0]);

    GenerateAuditsByMonthsChart(firstOfSixMonthBack.toISOString().split('T')[0], lastOfPrevMonth.toISOString().split('T')[0]);

    //Date range picker
    $('#auditdaterange').daterangepicker({ 
        startDate: firstOfCurrentMonth, // after open picker you'll see this dates as picked
        endDate: endDate,
        locale: {
            format: 'YYYY-MM-DD',
        }
    }, function(start, end, label) {
        GetAudits(start.toISOString().split('T')[0], end.toISOString().split('T')[0]);
    });

    $('#auditsumdaterange').daterangepicker({ 
        startDate: firstOfSixMonthBack, // after open picker you'll see this dates as picked
        endDate: lastOfPrevMonth,
        locale: {
            format: 'YYYY-MM-DD',
        }
    }, function(start, end, label) {
        GenerateAuditsByMonthsChart(start.toISOString().split('T')[0], end.toISOString().split('T')[0]);
    });
    
    function GetAudits(startDate, endDate)
    {
        $.post( "index.php?r=customers/get_completed_audits&start_date=" + startDate + "&end_date=" + endDate, function( data ) {
            $("#completed-audits").html(data);
            $("#completed-audits-table").DataTable({
                "responsive": true,
                "autoWidth": false,
                "lengthChange": false,
                });
        });

        $.post( "index.php?r=customers/get_not_completed_audits&start_date=" + startDate + "&end_date=" + endDate, function( data ) {
            $("#not-completed-audits").html(data);
            $("#not-completed-audits-table").DataTable({
                "responsive": true,
                "autoWidth": false,
                "lengthChange": false,
                });
        });

    }

    function GenerateAuditsByMonthsChart(startDate, endDate)
    {
        $.ajax({
        url:'index.php?r=customers/getauditsbymonthchartdata',
        method:'post',
        dataType:'json',
        success:function(data){
            
            var labelsArray = [];
            var dataArray = [];

            for(var i=0; i < data['result'].length; i++){
                labelsArray.push(data['result'][i]['month']);
                dataArray.push(data['result'][i]['count']);
            }

            var mode      = 'index';
            var intersect = true;
            var ticksStyle = {
                fontColor: '#495057',
                fontStyle: 'bold'
            }

            var $certificateCountsChart = $('#certificate-counts-chart')
            var certificateCountsChart  = new Chart($certificateCountsChart, {
                type   : 'bar',
                data   : {
                labels  : labelsArray,
                datasets: [
                    {
                    backgroundColor: '#007bff',
                    borderColor    : '#007bff',
                    data           : dataArray
                    }
                ]
                },
                options: {
                maintainAspectRatio: false,
                tooltips           : {
                    mode     : mode,
                    intersect: intersect
                },
                hover              : {
                    mode     : mode,
                    intersect: intersect
                },
                legend             : {
                    display: false
                },
                scales             : {
                    yAxes: [{
                    display: true,
                    gridLines: {
                        display      : true,
                        lineWidth    : '4px',
                        color        : 'rgba(0, 0, 0, .2)',
                        zeroLineColor: 'transparent'
                    },
                    ticks    : $.extend({
                        beginAtZero: true,

                        // Include a dollar sign in the ticks
                        callback: function (value, index, values) {
                        if (value >= 1000) {
                            value /= 1000
                            value += 'k'
                        }
                        return value
                        }
                    }, ticksStyle)
                    }],
                    xAxes: [{
                    display  : true,
                    gridLines: {
                        display: false
                    },
                    ticks    : ticksStyle
                    }]
                }
                }
            })
        }
        });
    }


    
});
</script>
