<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\UserRoles;

/* @var $this yii\web\View */
/* @var $model common\models\Cycles */
/* @var $form yii\widgets\ActiveForm */

?>

<div class="user-form">
    <?php $form = ActiveForm::begin([
        'options' => [
            'class' => 'needs-validation',
            'novalidate' => true,
            ]
    ]); ?>

    <?= $form->field($model, 'username')->textInput(['autofocus' => true]) ?>

    <?= $form->field($model, 'first_name') ?>

    <?= $form->field($model, 'last_name') ?>

    <?= $form->field($model, 'email') ?>

    <?= $form->field($model, 'password')->passwordInput() ?>

    <?= $form->field($model, 'user_role_id')->dropDownList(
            ArrayHelper::map(UserRoles::find()->all(),'id','role_name'), ['prompt'=>'Select a user role'])?>

    <?= $form->field($model, 'is_approver')->checkBox() ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('<i class="far fa-list-alt"></i> Users', ['index'], ['class' => 'btn btn-info']) ?>
    </div>

    <?php ActiveForm::end(); ?>
</div>
    
