<?php

namespace frontend\controllers;

use Yii;
use common\models\Certificates;
use common\models\CertificatesSearch;
use common\models\CustomerCertificates;
use common\models\CustomerCertificatesSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\db\Query;

/**
 * CertificatesController implements the CRUD actions for Certificates model.
 */
class CertificatesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Certificates models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new CertificatesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Certificates model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $queryCustomerCertificates = new Query;
        $queryCustomerCertificates->select(['customer_certificates.id as customer_certificates_id','customer_certificates.customers_id as customers_id', 'customer_certificates.customers_name', 'customer_certificates.accreditation', 'customer_certificates.multisite'])  
            ->from('customer_certificates')
            ->innerJoin('customers', 'customer_certificates.customers_id = customers.id and customer_certificates.certificates_id = '.$id)
            ->orderBy('customers_name')
            ->all(); 
                    
        $commandCustomerCertificates = $queryCustomerCertificates->createCommand();
        $customerCertificates = $commandCustomerCertificates->queryAll();

        return $this->render('view', [
            'model' => $this->findModel($id),
            'customerCertificates' => $customerCertificates,
        ]);
    }

    /**
     * Creates a new Certificates model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Certificates();

        if ($model->load(Yii::$app->request->post())) {

            $model->certification_category_name = $model->certificateCategories->category_name;
            $model->created_by = Yii::$app->user->identity->id;
            $model->created_on = date('Y-m-d H:i:s');
            $model->edited_by = Yii::$app->user->identity->id;
            $model->edited_on = date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Certificates model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Certificates model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Certificates model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return Certificates the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Certificates::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
