<?php

namespace frontend\controllers;

use Yii;
use common\models\Customers;
use common\models\CustomersSearch;
use common\models\CustomerCertificates;
use common\models\CustomerCertificatesSearch;
use common\models\AuditCycles;
use common\models\AuditCyclesSearch;
use common\models\AuditPhases;
use common\models\AuditPhasesSearch;
use common\models\DocumentTypes;
use common\models\DocumentTypesSearch;
use common\models\AuditDocuments;
use common\models\AuditDocumentsSearch;
use common\models\AuditDocumentsFiles;
use common\models\AuditDocumentsFilesSearch;
use common\models\PhaseAuditors;
use common\models\PhaseAuditorsSearch;
use common\models\Certificates;
use common\models\CertificatesSearch;
use common\models\CustomersHistory;
use common\models\CustomersHistorySearch;
use common\models\DefaultDocumentsSearch;
use common\models\IafCodeNaceCodesSearch;
use common\models\Phases;
use common\models\DeletedRecords;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\db\Query;
use yii\helpers\Html;

/**
 * CustomersController implements the CRUD actions for Customers model.
 */
class CustomersController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Finds the Customers model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return Customers the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Customers::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

    /**
     * Lists all Customers models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new CustomersSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Customers model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        $queryCustomerCertificates = new Query;
        $queryCustomerCertificates->select(['customer_certificates.id as customer_certificates_id', 'customer_certificates.customers_name','certificates.certification_category_name', 'certificates.reference_standard', 'customer_certificates.accreditation', 'customer_certificates.multisite','customer_certificates.secondary'])  
            ->from('customer_certificates')
            ->innerJoin('certificates', 'customer_certificates.certificates_id = certificates.id and customer_certificates.customers_id = '.$id)
            ->orderBy('certification_category_name')
            ->all(); 
                    
        $commandCustomerCertificates = $queryCustomerCertificates->createCommand();
        $customerCertificates = $commandCustomerCertificates->queryAll();

        return $this->render('view', [
            'model' => $this->findModel($id),
            'customerCertificates' => $customerCertificates,
        ]);
    }

    /**
     * Creates a new Customers model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Customers();

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                //Adding a record to customer history table
                $historyModel = new CustomersHistory();
                $historyModel->customers_id = $model->id;
                $historyModel->name = $model->name;
                $historyModel->head_office_address = $model->head_office_address;
                $historyModel->site_address = $model->site_address;
                $historyModel->first_contact = $model->first_contact;
                $historyModel->first_contact_designation = $model->first_contact_designation;
                $historyModel->first_contact_email = $model->first_contact_email;
                $historyModel->first_contact_phone_1 = $model->first_contact_phone_1;
                $historyModel->first_contact_phone_2 = $model->first_contact_phone_2;

                $historyModel->second_contact = $model->second_contact;
                $historyModel->second_contact_designation = $model->second_contact_designation;
                $historyModel->second_contact_email = $model->second_contact_email;
                $historyModel->second_contact_phone_1 = $model->second_contact_phone_1;
                $historyModel->second_contact_phone_2 = $model->second_contact_phone_2;

                $historyModel->joined_date = $model->joined_date;

                $historyModel->created_by=Yii::$app->user->identity->id;
                $historyModel->created_on=date('Y-m-d H:i:s');
                $historyModel->edited_by=Yii::$app->user->identity->id;
                $historyModel->edited_on=date('Y-m-d H:i:s');

                $historyModel->save();

                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Customers model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                //Adding a record to customer history table
                $historyModel = new CustomersHistory();
                $historyModel->customers_id = $model->id;
                $historyModel->name = $model->name;
                $historyModel->head_office_address = $model->head_office_address;
                $historyModel->site_address = $model->site_address;
                
                $historyModel->first_contact = $model->first_contact;
                $historyModel->first_contact_designation = $model->first_contact_designation;
                $historyModel->first_contact_email = $model->first_contact_email;
                $historyModel->first_contact_phone_1 = $model->first_contact_phone_1;
                $historyModel->first_contact_phone_2 = $model->first_contact_phone_2;

                $historyModel->second_contact = $model->second_contact;
                $historyModel->second_contact_designation = $model->second_contact_designation;
                $historyModel->second_contact_email = $model->second_contact_email;
                $historyModel->second_contact_phone_1 = $model->second_contact_phone_1;
                $historyModel->second_contact_phone_2 = $model->second_contact_phone_2;

                $historyModel->joined_date = $model->joined_date;

                $historyModel->created_by=Yii::$app->user->identity->id;
                $historyModel->created_on=date('Y-m-d H:i:s');
                $historyModel->edited_by=Yii::$app->user->identity->id;
                $historyModel->edited_on=date('Y-m-d H:i:s');

                $historyModel->save();

                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Customers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $customer = Customers::findOne($id);

        $deleted_record = $customer->name;
        
        try {
            $customer->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Customer";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

     /**
     * Displays a single CustomersHistory model.
     * @param int $customers_id customers id
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewcustomerhistory($customers_id)
    {
        $customer = Customers::findOne($customers_id);

        $customerHistorySearchModel = new CustomersHistorySearch();
        $customerHistorySearchModel->customers_id = $customers_id;

        $customerHistories = $customerHistorySearchModel->search([]);

        return $this->render('view-customer-history', [
            'customer' => $customer,
            'customerHistories' => $customerHistories,
        ]);
    }

    /**
     * Creates a new CustomerCertificates model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddcertificate($customers_id)
    {
        $model = new CustomerCertificates();
        $model->customers_id = $customers_id;

        if ($model->load(Yii::$app->request->post())) {

            $model->customers_name = $model->customers->name;
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                if ($model->secondary == 0)
                {
                    //get the list of cycles from default documents
                    $queryCycles = 'SELECT DISTINCT cycles_id FROM default_documents';
                    $cyclesList = yii::$app->db->createCommand($queryCycles)->queryAll();

                    foreach ($cyclesList as $cycle) {

                        $cycles_id = $cycle['cycles_id'];

                        // Add an audit cycle
                        $auditCycle = new AuditCycles();
                        $auditCycle->customer_certificates_id = $model->id;
                        $auditCycle->cycles_id = $cycles_id;
                        $auditCycle->created_by=Yii::$app->user->identity->id;
                        $auditCycle->created_on=date('Y-m-d H:i:s');
                        $auditCycle->edited_by=Yii::$app->user->identity->id;
                        $auditCycle->edited_on=date('Y-m-d H:i:s');

                        if ($auditCycle->save())
                        {
                            //get the phases for the selected cycle
                            $queryPhases = 'SELECT DISTINCT phases_id FROM default_documents '.
                                'WHERE cycles_id = "' . $cycles_id . '"';
                            $phasesList = yii::$app->db->createCommand($queryPhases)->queryAll();

                            foreach ($phasesList as $phase) {
                            
                                $phases_id = $phase['phases_id'];

                                $phaseObject = Phases::findOne($phases_id);

                                //Add an audit phase
                                $auditPhase = new AuditPhases();
                                $auditPhase->audit_cycles_id = $auditCycle->id;
                                $auditPhase->cycles_id = $auditCycle->cycles_id;
                                $auditPhase->phases_id = $phases_id;
                                $auditPhase->customer_certificates_id = $model->id;
                                $auditPhase->phases_name = $phaseObject->name;
                                $auditPhase->customers_id = $model->customers_id;
                                $auditPhase->customers_name = $model->customers_name;
                                $auditPhase->certificates_id = $model->certificates_id;
                                $auditPhase->audit_status_id = 1;

                                $auditPhase->created_by=Yii::$app->user->identity->id;
                                $auditPhase->created_on=date('Y-m-d H:i:s');
                                $auditPhase->edited_by=Yii::$app->user->identity->id;
                                $auditPhase->edited_on=date('Y-m-d H:i:s');

                                if ($auditPhase->save())
                                {
                                    //get the documents for the selected cycle and phase
                                    $documentSearchModel = new DefaultDocumentsSearch();
                                    $documentSearchModel->cycles_id = $cycles_id;
                                    $documentSearchModel->phases_id = $phases_id;

                                    $defaultDocuments = $documentSearchModel->search([]);

                                    foreach($defaultDocuments->getModels() as $defaultDocument) {

                                        $auditDocuments = new AuditDocuments();
                    
                                        $auditDocuments->audit_phases_id = $auditPhase->id;
                                        $auditDocuments->phases_id = $phases_id;
                                        $auditDocuments->cycles_id = $cycles_id;
                                        $auditDocuments->customers_id = $model->customers_id;
                                        $auditDocuments->customers_name = $model->customers_name;
                                        $auditDocuments->certificates_id = $model->certificates_id;
                                        $auditDocuments->document_types_id = $defaultDocument->document_types_id;
                                        $auditDocuments->document_types_name = $defaultDocument->document_types_name;
                                        $auditDocuments->file = "Please add the document here";
                    
                                        $auditDocuments->created_by= Yii::$app->user->identity->id;
                                        $auditDocuments->created_on = date('Y-m-d H:i:s');
                                        $auditDocuments->edited_by=Yii::$app->user->identity->id;
                                        $auditDocuments->edited_on=date('Y-m-d H:i:s');
                    
                                        $auditDocuments->save();
                    
                                    }
                                }
                            }
                        }
                    }
                }

                return $this->redirect(['view', 'id' => $customers_id]);
            }
            else
            {
                return $this->render('add-certificate', ['model' => $model,]);
            }
        } else {
            return $this->render('add-certificate', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Displays a single CustomerCertificates model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewcustomercertificate($customer_certificates_id)
    {
        $customerCertificate = CustomerCertificates::findOne($customer_certificates_id);
        
        if($customerCertificate->secondary == 1) {
            $parentCustomerCertificateSearchModel = new CustomerCertificatesSearch();
            $parentCustomerCertificateSearchModel->customers_id = $customerCertificate->customers_id;
            $parentCustomerCertificateSearchModel->certificate_categories_id = $customerCertificate->parent_certificate_categories_id;
            $parentCustomerCertificateSearchModel->certificates_id = $customerCertificate->parent_certificates_id;

            $parentCustomerCertificate = $parentCustomerCertificateSearchModel->search([]);

            if ($parentCustomerCertificate->getModels() != null) {
                $customer_certificates_id = $parentCustomerCertificate->getModels()[0]->id;
            }
        }

        $auditCyclesSearchModel = new AuditCyclesSearch();
        $auditCyclesSearchModel->customer_certificates_id = $customer_certificates_id;

        $auditCycles = $auditCyclesSearchModel->search([]);

        return $this->render('view-certificate', [
            'model' => $this->findModel($customerCertificate->customers_id),
            'customerCertificate' => $customerCertificate,
            'auditCycles' => $auditCycles,
        ]);
    }

    /**
     * Updates an existing AuditCycles model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdatecustomercertificate($customer_certificates_id)
    {
        $customerCertificate = CustomerCertificates::findOne($customer_certificates_id);

        if ($customerCertificate->load(Yii::$app->request->post())) {

            $customerCertificate->edited_by=Yii::$app->user->identity->id;
            $customerCertificate->edited_on=date('Y-m-d H:i:s');

            if ($customerCertificate->save())
            {
                $auditCyclesSearchModel = new AuditCyclesSearch();
                $auditCyclesSearchModel->customer_certificates_id = $customer_certificates_id;

                $auditCycles = $auditCyclesSearchModel->search([]);

                return $this->render('view-certificate', [
                    'model' => $this->findModel($customerCertificate->customers_id),
                    'customerCertificate' => $customerCertificate,
                    'auditCycles' => $auditCycles,
                ]);
            }
            else
            {
                return $this->render('update-certificate', ['model' => $customerCertificate,]);
            }
        } else {
            return $this->render('update-certificate', [
                'model' => $customerCertificate,
            ]);
        }
    }

        /**
     * Deletes an existing Customers model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDeletecustomercertificate($customer_certificates_id)
    {
        $customerCertificate = CustomerCertificates::findOne($customer_certificates_id);

        $deleted_record = $customerCertificate->customers_name.' - '.$customerCertificate->certificates->certification_category_name.' - '.$customerCertificate->certificates->reference_standard;

        try {
            $customerCertificate->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Customer";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

        /**
     * Creates a new AuditCycles model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddcycle($customer_certificates_id)
    {
        $model = new AuditCycles();
        $model->customer_certificates_id = $customer_certificates_id;

        if ($model->load(Yii::$app->request->post())) {
            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['viewcustomercertificate', 'customer_certificates_id' => $customer_certificates_id]);
            }
            else
            {
                return $this->render('add-cycle', ['model' => $model,]);
            }
        } else {
            return $this->render('add-cycle', [
                'model' => $model,
            ]);
        }
    }

        /**
     * Updates an existing AuditCycles model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdatecycle($audit_cycles_id)
    {
        $auditCycle = AuditCycles::findOne($audit_cycles_id);

        $old_committee_approval_date =  $auditCycle->committee_approval_date;

        if ($auditCycle->load(Yii::$app->request->post())) {

            $auditCycle->edited_by=Yii::$app->user->identity->id;
            $auditCycle->edited_on=date('Y-m-d H:i:s');

            if ($auditCycle->save())
            {
                //Updating the schedule dates of the phases
                $cycles_id = $auditCycle->cycles_id;

                $currentCycleSurv1Schedule = date('Y-m-d', strtotime($auditCycle->committee_approval_date. ' + 10 months'));

                $updateCurrentCycleSurv1= "UPDATE audit_phases 
                    SET schedule_date='$currentCycleSurv1Schedule' 
                    WHERE audit_cycles_id='$audit_cycles_id' 
                    AND cycles_id='$cycles_id' AND phases_id='4';";

		        yii::$app->db->createCommand($updateCurrentCycleSurv1)->execute();
                
                $currentCycleSurv2Schedule = date('Y-m-d', strtotime($currentCycleSurv1Schedule. ' + 12 months'));

                $updateCurrentCycleSurv2= "UPDATE audit_phases 
                    SET schedule_date='$currentCycleSurv2Schedule' 
                    WHERE audit_cycles_id='$audit_cycles_id' 
                    AND cycles_id='$cycles_id' AND phases_id='5';";

		        yii::$app->db->createCommand($updateCurrentCycleSurv2)->execute();

                $next_cycles_id = $cycles_id + 1;
                $next_audit_cycles_id = $audit_cycles_id + 1;

                $nextCycleReCetSchedule = date('Y-m-d', strtotime($currentCycleSurv2Schedule. ' + 9 months'));

                $updateNextCycleReCet= "UPDATE audit_phases 
                    SET schedule_date='$nextCycleReCetSchedule' 
                    WHERE audit_cycles_id='$next_audit_cycles_id' 
                    AND cycles_id='$next_cycles_id' AND phases_id='6';";

		        yii::$app->db->createCommand($updateNextCycleReCet)->execute();

                $auditPhasesSearchModel = new AuditPhasesSearch();
                $auditPhasesSearchModel->audit_cycles_id = $audit_cycles_id;
                $auditPhases = $auditPhasesSearchModel->search([]);

                return $this->render('view-cycle', [
                    'model' => $this->findModel($auditCycle->customerCertificates->customers_id),
                    'auditCycle' => $auditCycle,
                    'auditPhases' => $auditPhases,
                ]);
            }
            else
            {
                return $this->render('update-cycle', ['model' => $auditCycle,]);
            }
        } else {
            return $this->render('update-cycle', [
                'model' => $auditCycle,
            ]);
        }
    }


        /**
     * Displays a single AuditCycles model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewcycle($audit_cycles_id)
    {
        $auditCycle = AuditCycles::findOne($audit_cycles_id);

        $auditPhasesSearchModel = new AuditPhasesSearch();
        $auditPhasesSearchModel->audit_cycles_id = $audit_cycles_id;

        $auditPhases = $auditPhasesSearchModel->search([]);

        return $this->render('view-cycle', [
            'model' => $this->findModel($auditCycle->customerCertificates->customers_id),
            'auditCycle' => $auditCycle,
            'auditPhases' => $auditPhases,
        ]);
    }

        /**
     * Creates a new AuditPhases model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddphase($audit_cycles_id)
    { 
        $model = new AuditPhases();
        $model->audit_cycles_id = $audit_cycles_id;
        
        if ($model->load(Yii::$app->request->post())) {
             
            $model->phases_name = $model->phases->name;
            $model->customer_certificates_id = $model->auditCycles->customer_certificates_id;
            $model->cycles_id = $model->auditCycles->cycles_id;
            $model->customers_id = $model->customerCertificates->customers_id;
            $model->customers_name = $model->customerCertificates->customers_name;
            $model->certificates_id = $model->customerCertificates->certificates_id;

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                // Get Document Types
                $documentTypesSearchModel = new DocumentTypesSearch();
                $documentTypes = $documentTypesSearchModel->search([]);

                foreach($documentTypes->getModels() as $documentType) {

                    $auditDocuments = new AuditDocuments();

                    $auditDocuments->audit_phases_id = $model->id;
                    $auditDocuments->phases_id = $model->phases_id;
                    $auditDocuments->cycles_id = $model->auditCycles->cycles_id;
                    $auditDocuments->customers_id = $model->customers_id;
                    $auditDocuments->customers_name = $model->customers_name;
                    $auditDocuments->certificates_id = $model->certificates_id;
                    $auditDocuments->document_types_id = $documentType->id;
                    $auditDocuments->document_types_name = $documentType->name;
                    $auditDocuments->file = "Please add the document here";

                    $auditDocuments->created_by= Yii::$app->user->identity->id;
                    $auditDocuments->created_on = date('Y-m-d H:i:s');
                    $auditDocuments->edited_by=Yii::$app->user->identity->id;
                    $auditDocuments->edited_on=date('Y-m-d H:i:s');

                    $auditDocuments->save();

                }

                return $this->redirect(['viewcycle', 'audit_cycles_id' => $audit_cycles_id]);
            }
            else
            {
                return $this->render('add-phase', ['model' => $model,]);
            }
        } else {
            return $this->render('add-phase', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing AuditPhases model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdatephase($audit_phases_id)
    {
        $auditPhase = AuditPhases::findOne($audit_phases_id);

        if ($auditPhase->load(Yii::$app->request->post())) {

            $auditPhase->edited_by=Yii::$app->user->identity->id;
            $auditPhase->edited_on=date('Y-m-d H:i:s');

            if ($auditPhase->save())
            {
                $auditDocumentsSearchModel = new AuditDocumentsSearch();
                $auditDocumentsSearchModel->audit_phases_id = $audit_phases_id;

                $auditDocuments = $auditDocumentsSearchModel->search([]);

                $phaseAuditorsSearchModel = new PhaseAuditorsSearch();
                $phaseAuditorsSearchModel->audit_phases_id = $audit_phases_id;

                $phaseAuditors = $phaseAuditorsSearchModel->search([]);


                return $this->render('view-phase', [
                    'model' => $this->findModel($auditPhase->auditCycles->customerCertificates->customers_id),
                    'auditPhase' => $auditPhase,
                    'auditDocuments' => $auditDocuments,
                    'phaseAuditors' => $phaseAuditors,
                ]);
            }
            else
            {
                return $this->render('update-phase', ['model' => $auditPhase,]);
            }
        } else {
            return $this->render('update-phase', [
                'model' => $auditPhase,
            ]);
        }
    }

    /**
     * Displays a single Phases model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewphase($audit_phases_id)
    {
        $auditPhase = AuditPhases::findOne($audit_phases_id);

        $auditDocumentsSearchModel = new AuditDocumentsSearch();
        $auditDocumentsSearchModel->audit_phases_id = $audit_phases_id;

        $auditDocuments = $auditDocumentsSearchModel->search([]);


        $phaseAuditorsSearchModel = new PhaseAuditorsSearch();
        $phaseAuditorsSearchModel->audit_phases_id = $audit_phases_id;

        $phaseAuditors = $phaseAuditorsSearchModel->search([]);


        return $this->render('view-phase', [
            'model' => $this->findModel($auditPhase->auditCycles->customerCertificates->customers_id),
            'auditPhase' => $auditPhase,
            'auditDocuments' => $auditDocuments,
            'phaseAuditors' => $phaseAuditors,
        ]);
    }

        /**
     * Displays a single Phases model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionViewdocuments($audit_documents_id)
    {
        $auditDocument = AuditDocuments::findOne($audit_documents_id);

        $auditDocumentsFilesSearchModel = new AuditDocumentsFilesSearch();
        $auditDocumentsFilesSearchModel->audit_documents_id = $audit_documents_id;

        $auditDocumentsFiles = $auditDocumentsFilesSearchModel->search([]);

        $auditPhase = AuditPhases::findOne($auditDocument->audit_phases_id);

        return $this->render('view-documents', [
            'model' => $this->findModel($auditPhase->customers_id),
            'auditPhase' => $auditPhase,
            'auditDocument' => $auditDocument,
            'auditDocumentsFiles' => $auditDocumentsFiles,
        ]);
    }

     /**
     * Creates a new AuditDocumentsFiles model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionUploaddocuments($audit_documents_id)
    { 
        $model = new AuditDocumentsFiles();
        $model->audit_documents_id = $audit_documents_id;

        if ($model->load(Yii::$app->request->post())) {

            $total = count($_FILES['AuditDocumentsFiles']['name']); // multiple files
            $path = Yii::$app->basePath .'/web/uploads/customer_documents/'; // your upload path

            if($total >0 )
            {
                $tmpFilePath = $_FILES['AuditDocumentsFiles']['tmp_name']['audit_documents_file']; // the temp file path
                $fileName = $_FILES['AuditDocumentsFiles']['name']['audit_documents_file']; // the file name
                $fileSize = $_FILES['AuditDocumentsFiles']['size']['audit_documents_file']; // the file size

                if ($tmpFilePath != ""){
                    //Setup our new file path
                    $newFilePath = $path .'cd_'.$model->id.'_'. $fileName;
                    $newFileUrl = Yii::$app->basePath .'/web/uploads/customer_documents/' . $fileName;
                    
                    //Upload the file into the new path
                    if(move_uploaded_file($tmpFilePath, $newFilePath)) {
                        $fileId = $fileName . '1985'; // some unique key to identify the file
                        $preview[] = $newFileUrl;
                        $config[] = [
                            'key' => $fileId,
                            'caption' => $fileName,
                            'size' => $fileSize,
                            'downloadUrl' => $newFileUrl, // the url to download the file
                        ];
                    } else {
                        $errors[] = $fileName;
                    }
                } else {
                    $errors[] = $fileName;
                }
            }

            if($fileName)
            {
                $model->audit_documents_file = 'cd_'.$model->id.'_'.$fileName;
                $model->created_by=Yii::$app->user->identity->id;
                $model->created_on=date('Y-m-d H:i:s');
                $model->edited_by=Yii::$app->user->identity->id;
                $model->edited_on=date('Y-m-d H:i:s');

                if ($model->save())
                {                    
                    $auditDocument = AuditDocuments::findOne($audit_documents_id);

                    $auditDocumentsFilesSearchModel = new AuditDocumentsFilesSearch();
                    $auditDocumentsFilesSearchModel->audit_documents_id = $audit_documents_id;

                    $auditDocumentsFiles = $auditDocumentsFilesSearchModel->search([]);

                    Yii::$app->session->setFlash('uploadSuccess', 'The file uploaded successfully.');

                    return $this->render('view-documents', [
                        'model' => $this->findModel($model->auditDocuments->customers_id),
                        'auditPhase' => $model->auditDocuments->auditPhases,
                        'auditDocument' => $auditDocument,
                        'auditDocumentsFiles' => $auditDocumentsFiles,
                    ]);

                } else {
                    return $this->render('add-document', ['model' => $model,]);
                }
            }
        } else {
            return $this->render('add-document', [
                'model' => $model,
            ]);
        }

    }

            /**
     * Displays a single Phases model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionAdddocuments($audit_documents_files_id)
    {
        $auditDocumentFile = AuditDocumentsFiles::findOne($audit_documents_files_id);

        return $this->render('add-document', [
            'model' => $auditDocumentFile,
        ]);
    }

    /**
     * Deletes an existing Industries model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDeletedocument($audit_documents_files_id)
    {
        $auditDocumentFile = AuditDocumentsFiles::findOne($audit_documents_files_id);

        $deleted_record = $auditDocumentFile->audit_documents_file;
        try {
            $auditDocumentFile->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Audit Documents";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

        /**
     * Creates a new PhaseAuditors model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAddauditor($audit_phases_id)
    { 
        $model = new PhaseAuditors();
        $model->audit_phases_id = $audit_phases_id;
        
        if ($model->load(Yii::$app->request->post())) {
             
            $model->auditors_name = $model->auditors->full_name;
            $model->attended = 0;

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            /*echo "<pre>";
                print_r($model);
                exit();*/

            if ($model->save())
            {
                return $this->redirect(['viewphase', 'audit_phases_id' => $audit_phases_id]);
            }
            else
            {
                return $this->render('add-auditor', ['model' => $model,]);
            }
        } else {
            return $this->render('add-auditor', [
                'model' => $model,
            ]);
        }
    }

    public function actionDeleteauditor($phase_auditors_id)
    {
        $phaseAuditor = PhaseAuditors::findOne($phase_auditors_id);

        $audit_phases_id = $phaseAuditor->audit_phases_id;

        $phaseAuditor->delete();

        return $this->redirect(['viewphase', 'audit_phases_id' => $audit_phases_id]);
    }

                /**
     * Creates a new PhaseAuditors model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionAdddocumenttype($audit_phases_id)
    { 

        $auditPhase = AuditPhases::findOne($audit_phases_id);

        $model = new AuditDocuments();
        $model->audit_phases_id = $audit_phases_id;
        $model->phases_id = $auditPhase->phases_id;
        $model->cycles_id = $auditPhase->cycles_id;
        
        if ($model->load(Yii::$app->request->post())) {
             
            $model->customers_id = $auditPhase->customers_id;
            $model->customers_name = $auditPhase->customers_name;
            $model->certificates_id = $auditPhase->certificates_id;
            $model->document_types_name = $model->documentTypes->name;
            $model->file = "Please add the document here";

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            /*echo "<pre>";
                print_r($model);
                exit();*/

            if ($model->save())
            {
                return $this->redirect(['viewphase', 'audit_phases_id' => $audit_phases_id]);
            }
            else
            {
                return $this->render('add-auditor', ['model' => $model,]);
            }
        } else {
            return $this->render('add-document-type', [
                'model' => $model,
            ]);
        }
    }

        /**
     * Deletes an existing Industries model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDeletedocumenttype($audit_documents_id)
    {
        $auditDocument = AuditDocuments::findOne($audit_documents_id);

        $deleted_record = $auditDocument->document_types_name;

        try {
            $auditDocument->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Document Type";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }


    public function actionUpdateattendance($id, $is_attended)
    {
        $phaseAuditor = PhaseAuditors::findOne($id);
        $phaseAuditor->attended = $is_attended;
        $phaseAuditor->save();

        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        return [
            'message' => 'Attendance saved successfully.',
            'code' => 200,
        ];
    }

    public function actionGet_completed_audits($start_date, $end_date)
    {
        $whereCondition =  " WHERE ap.audit_status_id = 2 AND ap.schedule_date >= '" . $start_date . "' AND ap.schedule_date <= '" . $end_date . "'";

        $queryPhasesCycles = 'SELECT DISTINCT ad.customers_name, ad.customers_id, '.
            'ce.certification_category_name, cc.accreditation, cc.multisite, ap.customer_certificates_id, '.
            'ap.phases_name, c.cycle_name, ap.audit_cycles_id, ap.id, ap.schedule_date'.
            ' FROM audit_documents ad '. 
            ' INNER JOIN cycles c on c.id = ad.cycles_id '. 
            ' INNER JOIN phases p on p.id = ad.phases_id '. 
            ' INNER JOIN certificates ce on ce.id = ad.certificates_id '.
            ' INNER JOIN audit_phases ap on ap.id = ad.audit_phases_id '.
            ' INNER JOIN customer_certificates cc on cc.id = ap.customer_certificates_id '.
            $whereCondition . ";";
        $phasesCyclesList = yii::$app->db->createCommand($queryPhasesCycles)->queryAll();

        echo '<table id="completed-audits-table" class="table table-bordered table-striped">';
        echo '<thead>
                <tr>
                    <th>Customer</th>
                    <th>Certificate</th>
                    <th>Is Accredited</th>
                    <th>Is Multi-site</th>
                    <th>Cycle</th>
                    <th>Phase</th>
                    <th>Schedule Date</th>
                </tr></thead><tbody>';

        foreach ($phasesCyclesList as $phasesCycle) {

            echo '<tr>';
            echo '<td>' . Html::a($phasesCycle['customers_name'], ['/customers/view','id' => $phasesCycle['customers_id']]) . '</td>';
            echo '<td>' . Html::a($phasesCycle['certification_category_name'], ['/customers/viewcustomercertificate','customer_certificates_id' => $phasesCycle['customer_certificates_id']]) . '</td>';
            echo '<td>' . ($phasesCycle['accreditation'] == 1 ? "Yes" : "No") . '</td>';
            echo '<td>' . ($phasesCycle['multisite'] == 1 ? "Yes" : "No") . '</td>';
            echo '<td>' . Html::a($phasesCycle['cycle_name'], ['/customers/viewcycle','audit_cycles_id' => $phasesCycle['audit_cycles_id']]) . '</td>';
            echo '<td>' . Html::a($phasesCycle['phases_name'], ['/customers/viewphase','audit_phases_id' => $phasesCycle['id']]) . '</td>';
            echo '<td>' . ($phasesCycle['schedule_date']) . '</td>';
            echo '</tr>';
        }
        
        echo '</tbody><tfoot><tr>
            <th>Customer</th>
            <th>Certificate</th>
            <th>Is Accredited</th>
            <th>Is Multi-site</th>
            <th>Cycle</th>
            <th>Phase</th>
            <th>Schedule Date</th>
            </tr></tfoot></table>';

    }

    public function actionGet_not_completed_audits($start_date, $end_date)
    {
        $whereCondition =  " WHERE ap.audit_status_id != 2 AND ap.schedule_date >= '" . $start_date . "' AND ap.schedule_date <= '" . $end_date . "'";

        $queryPhasesCycles = 'SELECT DISTINCT ad.customers_name, ad.customers_id, '.
            'ce.certification_category_name, cc.accreditation, cc.multisite, ap.customer_certificates_id, '.
            'ap.phases_name, c.cycle_name, ap.audit_cycles_id, ap.id, ap.schedule_date'.
            ' FROM audit_documents ad '. 
            ' INNER JOIN cycles c on c.id = ad.cycles_id '. 
            ' INNER JOIN phases p on p.id = ad.phases_id '. 
            ' INNER JOIN certificates ce on ce.id = ad.certificates_id '.
            ' INNER JOIN audit_phases ap on ap.id = ad.audit_phases_id '.
            ' INNER JOIN customer_certificates cc on cc.id = ap.customer_certificates_id '.
            $whereCondition . ";";
        $phasesCyclesList = yii::$app->db->createCommand($queryPhasesCycles)->queryAll();

        echo '<table id="not-completed-audits-table" class="table table-bordered table-striped">';
        echo '<thead>
                <tr>
                    <th>Customer</th>
                    <th>Certificate</th>
                    <th>Is Accredited</th>
                    <th>Is Multi-site</th>
                    <th>Cycle</th>
                    <th>Phase</th>
                    <th>Schedule Date</th>
                </tr></thead><tbody>';

        foreach ($phasesCyclesList as $phasesCycle) {

            echo '<tr>';
            echo '<td>' . Html::a($phasesCycle['customers_name'], ['/customers/view','id' => $phasesCycle['customers_id']]) . '</td>';
            echo '<td>' . Html::a($phasesCycle['certification_category_name'], ['/customers/viewcustomercertificate','customer_certificates_id' => $phasesCycle['customer_certificates_id']]) . '</td>';
            echo '<td>' . ($phasesCycle['accreditation'] == 1 ? "Yes" : "No") . '</td>';
            echo '<td>' . ($phasesCycle['multisite'] == 1 ? "Yes" : "No") . '</td>';
            echo '<td>' . Html::a($phasesCycle['cycle_name'], ['/customers/viewcycle','audit_cycles_id' => $phasesCycle['audit_cycles_id']]) . '</td>';
            echo '<td>' . Html::a($phasesCycle['phases_name'], ['/customers/viewphase','audit_phases_id' => $phasesCycle['id']]) . '</td>';
            echo '<td>' . ($phasesCycle['schedule_date']) . '</td>';
            echo '</tr>';
        }
        
        echo '</tbody><tfoot><tr>
            <th>Customer</th>
            <th>Certificate</th>
            <th>Is Accredited</th>
            <th>Is Multi-site</th>
            <th>Cycle</th>
            <th>Phase</th>
            <th>Schedule Date</th>
            </tr></tfoot></table>';

    }

    public function actionGetauditsbymonthchartdata()
    {
        $queryAuditsbymonth = "SELECT DATE_FORMAT(schedule_date, '%b %Y') as month, COUNT(id) as count ".
         "from audit_phases GROUP BY MONTH(schedule_date), YEAR(schedule_date)".";";

        $resultAuditsbymonth = yii::$app->db->createCommand($queryAuditsbymonth)->queryAll();

        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        return [
            'message' => 'Audit data grouped successfully.',
            'code' => 200,
            'result' => $resultAuditsbymonth,
        ];
    }

    public function actionList_certificates_for_category($certificate_categories_id)
    {
        $certificatesSearchModel = new CertificatesSearch();
        $certificatesSearchModel->certificate_categories_id = $certificate_categories_id;

        $certificates = $certificatesSearchModel->search([])->getModels();

        echo "<option>Select a reference standard</option>";
        
        foreach ($certificates as $certificate) {
            echo "<option value='".$certificate->id."'>".$certificate->reference_standard."</option>";
        }

    }

    public function actionGet_iaf_code_for_nace_code($nace_codes_id)
    {
        $iafCodeNaceCodesSearchModel = new IafCodeNaceCodesSearch();
        $iafCodeNaceCodesSearchModel->nace_codes_id = $nace_codes_id;

        $iafCodeNaceCodes = $iafCodeNaceCodesSearchModel->search([])->getModels();

        $iaf_codes_id = 0;

        if (count($iafCodeNaceCodes)>0) {
            $iaf_codes_id = $iafCodeNaceCodes[0]->iaf_codes_id;
        }

        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

        return [
            'iaf_codes_id' => $iaf_codes_id,
            'code' => 200,
        ];
    }

}
