<?php

namespace frontend\controllers;

use Yii;
use common\models\Industries;
use common\models\IndustriesSearch;
use common\models\DeletedRecords;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\db\Exception;

/**
 * IndustriesController implements the CRUD actions for Industries model.
 */
class IndustriesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Industries models.
     *
     * @return string
     */
    public function actionIndex()
    {
        $searchModel = new IndustriesSearch();
        $dataProvider = $searchModel->search($this->request->queryParams);

        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }

    /**
     * Displays a single Industries model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Industries model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Industries();

        if ($model->load(Yii::$app->request->post())) {

            $model->created_by=Yii::$app->user->identity->id;
            $model->created_on=date('Y-m-d H:i:s');
            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('create', ['model' => $model,]);
            }
        } else {
            return $this->render('create', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Updates an existing Industries model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($model->load(Yii::$app->request->post())) {

            $model->edited_by=Yii::$app->user->identity->id;
            $model->edited_on=date('Y-m-d H:i:s');

            if ($model->save())
            {
                return $this->redirect(['view', 'id' => $model->id]);
            }
            else
            {
                return $this->render('update', ['model' => $model,]);
            }
        } else {
            return $this->render('update', [
                'model' => $model,
            ]);
        }
    }

    /**
     * Deletes an existing Industries model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $model = $this->findModel($id);
        $deleted_record = $model->industry_name;
        try {
            $model->delete();
        } catch (\yii\db\Exception $e) {
            return 0;
        }

        // Adding details to deleted records table
        $deletedItem = new DeletedRecords();

        $deletedItem->area_name= "Industries";
        $deletedItem->deleted_record = $deleted_record;
        $deletedItem->created_by=Yii::$app->user->identity->id;
        $deletedItem->created_on=date('Y-m-d H:i:s');
        $deletedItem->save();
        
        return 1;
    }

    /**
     * Finds the Industries model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return Industries the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Industries::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
