<?php

namespace frontend\controllers;

use Yii;
use common\models\Customers;
use common\models\CustomersSearch;
use common\models\Searches;
use yii\data\ActiveDataProvider;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\db\Query;

/**
 * SearchesController implements the CRUD actions for Searches model.
 */
class SearchesController extends Controller
{
    /**
     * @inheritDoc
     */
    public function behaviors()
    {
        return array_merge(
            parent::behaviors(),
            [
                'verbs' => [
                    'class' => VerbFilter::className(),
                    'actions' => [
                        'delete' => ['POST'],
                    ],
                ],
            ]
        );
    }

    /**
     * Lists all Searches models.
     *
     * @return string
     */
    public function actionIndex()
    {

        $searchModel = new Searches();
        $whereCondition = '';

        if ($this->request->isPost) {

            if ($searchModel->load($this->request->post())) {

                if ($searchModel->customers_id) {
                    $whereCondition =  ' WHERE ' . 'ad.customers_id = '. $searchModel->customers_id;
                }

                if ($searchModel->certificates_id) {
                    $whereCondition = $whereCondition . ($whereCondition == '' ? ' WHERE ' .  'ad.certificates_id = '. $searchModel->certificates_id : ' AND ' .  'ad.certificates_id = '. $searchModel->certificates_id);
                } 

                if ($searchModel->audit_phases_id) {
                    $whereCondition = $whereCondition . ($whereCondition == '' ? ' WHERE ' .  'ad.phases_id = '. $searchModel->audit_phases_id : ' AND ' .  'ad.phases_id = '. $searchModel->audit_phases_id);
                }

                if ($searchModel->audit_phases_id) {
                    $whereCondition = $whereCondition . ($whereCondition == '' ? ' WHERE ' .  'ad.cycles_id = '. $searchModel->audit_cycles_id : ' AND ' .  'ad.cycles_id = '. $searchModel->audit_cycles_id);
                }

                if ($searchModel->accreditation == 0 || $searchModel->accreditation == 1 ) {
                    $whereCondition = $whereCondition . ($whereCondition == '' ? ' WHERE ' .  'cc.accreditation = '. $searchModel->accreditation : ' AND ' .  'cc.accreditation = '. $searchModel->accreditation);
                }

                /*echo "<pre>";
                print_r($whereCondition);
                exit();*/

                // Customers list
                $queryCustomers = 'SELECT DISTINCT ad.customers_name, ad.customers_id'.
                    ' FROM audit_documents ad '. 
                    ' INNER JOIN cycles c on c.id = ad.cycles_id '. 
                    ' INNER JOIN phases p on p.id = ad.phases_id '. 
                    ' INNER JOIN certificates ce on ce.id = ad.certificates_id '.
                    ' INNER JOIN audit_phases ap on ap.id = ad.audit_phases_id '.
                    ' INNER JOIN customer_certificates cc on cc.id = ap.customer_certificates_id '.
                    $whereCondition . ";";
                $resultCustomers = yii::$app->db->createCommand($queryCustomers)->queryAll();

                // Customer Certificates list
                $queryCustomerCertificates = 'SELECT DISTINCT ad.customers_name, ad.customers_id, ce.certification_category_name, cc.accreditation, ap.customer_certificates_id'.
                    ' FROM audit_documents ad '. 
                    ' INNER JOIN cycles c on c.id = ad.cycles_id '. 
                    ' INNER JOIN phases p on p.id = ad.phases_id '. 
                    ' INNER JOIN certificates ce on ce.id = ad.certificates_id '.
                    ' INNER JOIN audit_phases ap on ap.id = ad.audit_phases_id '.
                    ' INNER JOIN customer_certificates cc on cc.id = ap.customer_certificates_id '.
                    $whereCondition . ";";
                $resultCustomerCertificates = yii::$app->db->createCommand($queryCustomerCertificates)->queryAll();

                // Customer Phase and Cycles list
                $queryPhasesCycles = 'SELECT DISTINCT ad.customers_name, ad.customers_id, ce.certification_category_name, cc.accreditation, ap.customer_certificates_id, ap.phases_name, c.cycle_name, ap.audit_cycles_id, ap.id, adts.status_name '.
                    ' FROM audit_documents ad '. 
                    ' INNER JOIN cycles c on c.id = ad.cycles_id '. 
                    ' INNER JOIN phases p on p.id = ad.phases_id '. 
                    ' INNER JOIN certificates ce on ce.id = ad.certificates_id '.
                    ' INNER JOIN audit_phases ap on ap.id = ad.audit_phases_id '.
                    ' INNER JOIN customer_certificates cc on cc.id = ap.customer_certificates_id '.
                    ' INNER JOIN audit_status adts on adts.id = ap.audit_status_id '.
                    $whereCondition . ";";
                $resultPhasesCycles = yii::$app->db->createCommand($queryPhasesCycles)->queryAll();


                $queryAuditDocuments = 'SELECT ad.*, c.cycle_name, p.name, ce.certification_category_name, cc.accreditation, ap.customer_certificates_id, ap.phases_name, ap.audit_cycles_id'.
                    ' FROM audit_documents ad '. 
                    ' INNER JOIN cycles c on c.id = ad.cycles_id '. 
                    ' INNER JOIN phases p on p.id = ad.phases_id '. 
                    ' INNER JOIN certificates ce on ce.id = ad.certificates_id '.
                    ' INNER JOIN audit_phases ap on ap.id = ad.audit_phases_id '.
                    ' INNER JOIN customer_certificates cc on cc.id = ap.customer_certificates_id '.
                    $whereCondition . ";";
                $resultAuditDocuments = yii::$app->db->createCommand($queryAuditDocuments)->queryAll();

                /*echo "<pre>";
                print_r($queryPhasesCycles);
                exit();*/

                return $this->render('index', [
                    'searchModel' => $searchModel,
                    'customersList' => $resultCustomers,
                    'customerCertificatesList' => $resultCustomerCertificates,
                    'phasesCyclesList' => $resultPhasesCycles,
                    'auditDocuments' => $resultAuditDocuments,
                ]);
            }
        } else {
            return $this->render('index', [
                'searchModel' => $searchModel,
                'customersList' => [],
                'customerCertificatesList' => [],
                'phasesCyclesList' => [],
                'auditDocuments' => [],
            ]);
        }

    }

    /**
     * Displays a single Searches model.
     * @param int $id ID
     * @return string
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionView($id)
    {
        return $this->render('view', [
            'model' => $this->findModel($id),
        ]);
    }

    /**
     * Creates a new Searches model.
     * If creation is successful, the browser will be redirected to the 'view' page.
     * @return string|\yii\web\Response
     */
    public function actionCreate()
    {
        $model = new Searches();

        if ($this->request->isPost) {
            if ($model->load($this->request->post()) && $model->save()) {
                return $this->redirect(['view', 'id' => $model->id]);
            }
        } else {
            $model->loadDefaultValues();
        }

        return $this->render('create', [
            'model' => $model,
        ]);
    }

    /**
     * Updates an existing Searches model.
     * If update is successful, the browser will be redirected to the 'view' page.
     * @param int $id ID
     * @return string|\yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionUpdate($id)
    {
        $model = $this->findModel($id);

        if ($this->request->isPost && $model->load($this->request->post()) && $model->save()) {
            return $this->redirect(['view', 'id' => $model->id]);
        }

        return $this->render('update', [
            'model' => $model,
        ]);
    }

    /**
     * Deletes an existing Searches model.
     * If deletion is successful, the browser will be redirected to the 'index' page.
     * @param int $id ID
     * @return \yii\web\Response
     * @throws NotFoundHttpException if the model cannot be found
     */
    public function actionDelete($id)
    {
        $this->findModel($id)->delete();

        return $this->redirect(['index']);
    }

    /**
     * Finds the Searches model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param int $id ID
     * @return Searches the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Searches::findOne(['id' => $id])) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }
}
