<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = 'Manage Document Approvals';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Document Approvals</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Document Approvals</li>
        </ol>
        
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage document approvals</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="document-approval-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Customer</th>
                    <th>Certificate</th>
                    <th>Is Accredited</th>
                    <th>Cycle</th>
                    <th>Phase</th>
                    <th>Document Type</th>
                    <th>File</th>
                    <th>Approval</th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $auditDocument): ?>
                
                  <?php if($auditDocument->is_approved == 0) { ?>
                  <tr>
                    <td><?= Html::encode($auditDocument->customers_name); ?></td>
                    <td><?= Html::encode($auditDocument->certificates->certification_category_name); ?></td>
                    <td><?= Html::encode($auditDocument->auditPhases->customerCertificates->accreditation == 1? 'Yes' : 'No'); ?></td>
                    <td><?= Html::encode($auditDocument->cycles->cycle_name); ?></td>
                    <td><?= Html::encode($auditDocument->auditPhases->phases_name); ?></td>
                    <td><?= Html::encode($auditDocument->document_types_name); ?></td>
                    <td><?= Html::a('<i class="fa fa-paperclip"></i>', ['customers/uploaddocuments','audit_documents_id' => $auditDocument->id], ['class' => 'btn btn-warning']) ?></td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" 
                              name="is_approve<?=$auditDocument->id?>" 
                              id="is_approve<?=$auditDocument->id ?>" 
                              onchange="approvalChange(<?=$auditDocument->id?>)"
                              <?= ($auditDocument->is_approved==1 ? 'checked' : '');?>
                        >
                    </td>

                  </tr>
                  <?php } ?>
                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Customer</th>
                    <th>Certificate</th>
                    <th>Is Accredited</th>
                    <th>Cycle</th>
                    <th>Phase</th>
                    <th>Document Type</th>
                    <th>File</th>
                    <th>Approval</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#document-approval-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>
