<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\grid\ActionColumn;
use yii\grid\GridView;

/* @var $this yii\web\View */
/* @var $searchModel common\models\AuditPhasesSearch */
/* @var $dataProvider yii\data\ActiveDataProvider */

$this->title = 'Audit Phases';
$this->params['breadcrumbs'][] = $this->title;
?>
<div class="audit-phases-index">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Create Audit Phases', ['create'], ['class' => 'btn btn-success']) ?>
    </p>

    <?php // echo $this->render('_search', ['model' => $searchModel]); ?>

    <?= GridView::widget([
        'dataProvider' => $dataProvider,
        'filterModel' => $searchModel,
        'columns' => [
            ['class' => 'yii\grid\SerialColumn'],

            'id',
            'audit_cycles_id',
            'phases_id',
            'phases_name',
            'customer_certificates_id',
            //'customers_id',
            //'customers_name',
            //'certificates_id',
            //'calling_date',
            //'schedule_date',
            //'actual_start_date',
            //'actual_end_date',
            //'created_on',
            //'created_by',
            //'edited_on',
            //'edited_by',
            [
                'class' => ActionColumn::className(),
                'urlCreator' => function ($action, AuditPhases $model, $key, $index, $column) {
                    return Url::toRoute([$action, 'id' => $model->id]);
                 }
            ],
        ],
    ]); ?>


</div>
