<?php

use yii\helpers\Html;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\AuditPhases */

$this->title = $model->id;
$this->params['breadcrumbs'][] = ['label' => 'Audit Phases', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>
<div class="audit-phases-view">

    <h1><?= Html::encode($this->title) ?></h1>

    <p>
        <?= Html::a('Update', ['update', 'id' => $model->id], ['class' => 'btn btn-primary']) ?>
        <?= Html::a('Delete', ['delete', 'id' => $model->id], [
            'class' => 'btn btn-danger',
            'data' => [
                'confirm' => 'Are you sure you want to delete this item?',
                'method' => 'post',
            ],
        ]) ?>
    </p>

    <?= DetailView::widget([
        'model' => $model,
        'attributes' => [
            'id',
            'audit_cycles_id',
            'phases_id',
            'phases_name',
            'customer_certificates_id',
            'customers_id',
            'customers_name',
            'certificates_id',
            'calling_date',
            'schedule_date',
            'actual_start_date',
            'actual_end_date',
            'created_on',
            'created_by',
            'edited_on',
            'edited_by',
        ],
    ]) ?>

</div>
