<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = 'Manage Auditor Categories';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Auditor Categories</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Auditor Categories</li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage auditor categories</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="auditor-categories-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Auditor Category</th>
                    
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $auditorCategory): ?>

                  <tr>
                    <td><?= Html::encode($auditorCategory->category_name); ?></td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Auditor Category</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#auditor-categories-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>
