<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = $model->type_name;
$this->params['breadcrumbs'][] = ['label' => 'Certificate Types', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Certificate Types', ['index']) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Certificate Types', ['index'], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="far fa-trash-alt"></i> Delete', ['delete', 'id' => $model->id], [
                        'class' => 'btn btn-danger',
                        'data' => [
                            'confirm' => 'Are you sure you want to delete this certificate type?',
                            'method' => 'post',
                        ],
                    ]) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('type_name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->type_name ?>
                        </dd>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>
