<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\CertificateTypes;
use common\models\CertificateCategories;

/* @var $this yii\web\View */
/* @var $model common\models\Certificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'certificate_types_id')->dropDownList(
            ArrayHelper::map(CertificateTypes::find()->all(),'id','type_name'), ['prompt'=>'Select a certificate type'])?> 
    
    <?= $form->field($model, 'certificate_categories_id')->dropDownList(
            ArrayHelper::map(CertificateCategories::find()->all(),'id','category_name'), ['prompt'=>'Select a certificate category'])?> 

    <?= $form->field($model, 'reference_standard')->textInput(['maxlength' => true]) ?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
