<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use kartik\date\DatePicker;

use common\models\Auditors;

/* @var $this yii\web\View */
/* @var $model common\models\PhaseAuditors */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="phase-auditors-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'audit_phases_id')->hiddenInput()->label(false); ?>
    <?= $form->field($model->auditPhases, 'phases_name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    <?= $form->field($model, 'auditors_id')->dropDownList(
            ArrayHelper::map(Auditors::find()->all(),'id','full_name'), ['prompt'=>'Select an auditor'])?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
        <?= Html::a('<i class="far fa-list-alt"></i> Audit Phases', ['viewphase','audit_phases_id' => $model->audit_phases_id], ['class' => 'btn btn-info']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
