<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = 'View Customer History';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">View Customer History</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Customers', ['index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a($customer->name, ['view', 'id' => $customer->id]) ?></li>
          <li class="breadcrumb-item active">View Customer History</li>
        </ol>
        <?= Html::a('<i class="far fa-list-alt"></i> View Customer', ['/customers/view', 'id' => $customer->id], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage customers</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="customers-history-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Modified Date</th>
                    <th>Customer</th>
                    <th>Email</th>
                    <th>General Phone</th>
                    <th>First Contact</th>
                    <th>First Contact Designation</th>
                    <th>First Contact Email</th>
                    <th>First Contact Phone 1</th>
                    <th>First Contact Phone 2</th>
                    <th>Second Contact</th>
                    <th>Second Contact Designation</th>
                    <th>Second Contact Email</th>
                    <th>Second Contact Phone 1</th>
                    <th>Second Contact Phone 2</th>
                    <th>Head Office Address</th>
                    <th>Site Address</th>
                    <th>Joined Date</th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($customerHistories->getModels() as $customerHistory): ?>

                  <tr>
                    <td><?= Html::encode($customerHistory->created_on); ?></td>
                    <td><?= Html::encode($customerHistory->name); ?></td>
                    <td><?= Html::encode($customerHistory->company_email); ?></td>
                    <td><?= Html::encode($customerHistory->general_phone); ?></td>
                    <td><?= Html::encode($customerHistory->first_contact); ?></td>
                    <td><?= Html::encode($customerHistory->first_contact_designation); ?></td>
                    <td><?= Html::encode($customerHistory->first_contact_email); ?></td>
                    <td><?= Html::encode($customerHistory->first_contact_phone_1); ?></td>
                    <td><?= Html::encode($customerHistory->first_contact_phone_2); ?></td>
                    <td><?= Html::encode($customerHistory->second_contact); ?></td>
                    <td><?= Html::encode($customerHistory->second_contact_designation); ?></td>
                    <td><?= Html::encode($customerHistory->second_contact_email); ?></td>
                    <td><?= Html::encode($customerHistory->second_contact_phone_1); ?></td>
                    <td><?= Html::encode($customerHistory->second_contact_phone_2); ?></td>
                    <td><?= Html::encode($customerHistory->head_office_address); ?></td>
                    <td><?= Html::encode($customerHistory->site_address); ?></td>
                    <td><?= Html::encode($customerHistory->joined_date); ?></td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Modified Date</th>
                    <th>Customer</th>
                    <th>Email</th>
                    <th>General Phone</th>
                    <th>First Contact</th>
                    <th>First Contact Designation</th>
                    <th>First Contact Email</th>
                    <th>First Contact Phone 1</th>
                    <th>First Contact Phone 2</th>
                    <th>Second Contact</th>
                    <th>Second Contact Designation</th>
                    <th>Second Contact Email</th>
                    <th>Second Contact Phone 1</th>
                    <th>Second Contact Phone 2</th>
                    <th>Head Office Address</th>
                    <th>Site Address</th>
                    <th>Joined Date</th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#customers-history-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>