<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\ActiveForm;
use yii\widgets\DetailView;
use kartik\file\FileInput;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = $model->name.' > '. $auditPhase->certificates->certification_category_name.' > '. $auditPhase->auditCycles->cycles->cycle_name.' > '.$auditPhase->phases->name.' > '.$auditDocument->document_types_name;
$this->params['breadcrumbs'][] = ['label' => 'Customers Certificate', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Customers', ['index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Customer Certificates', ['view', 'id' => $model->id]) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Audit Cycles', ['viewcustomercertificate', 'customer_certificates_id' => $auditPhase->auditCycles->customer_certificates_id]) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Audit Phases', ['viewcycle', 'audit_cycles_id' => $auditPhase->auditCycles->id]) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Document Types', ['viewphase', 'audit_phases_id' => $auditPhase->id]) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($auditDocument->document_types_name) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <?php if (Yii::$app->session->hasFlash('uploadSuccess')){ ?>
                  <div class="alert alert-success">
                      <!-- flash message -->
                      The file uploaded successfully.
                  </div>
                <?php } ?>
              </div>
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit Phase', ['updatephase', 'audit_phases_id' => $auditPhase->id], ['class' => 'btn btn-warning']) ?>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Documents', ['uploaddocuments', 'audit_documents_id' => $auditDocument->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Audit Phases', ['viewcycle', 'audit_cycles_id' => $auditPhase->auditCycles->id], ['class' => 'btn btn-info']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-header">
                <h2 class="card-title text-primary">Audit Documents</h2>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="documents-table" class="table table-bordered table-striped">
                  <thead>
                    <tr>
                        <th>File</th>
                        <th></th>
                    </tr>
                    </thead>
                    <tbody>

                    <?php foreach($auditDocumentsFiles->getModels() as $auditDocument): ?>

                        <tr>
                        <td><?= Html::encode($auditDocument->audit_documents_file); ?></td>
                        <td>
                            <?= Html::a('<i class="fa fa-paperclip"></i>', ['customers/adddocuments','audit_documents_files_id' => $auditDocument->id], ['class' => 'btn btn-warning']) ?>
                            <button class="btn btn-danger" id="btnDelete<?= Html::encode($auditDocument->id)?>" onclick="deleteAuditDocument(<?= Html::encode($auditDocument->id)?>,<?= Html::encode($auditDocument->audit_documents_id)?>);" ><i class="far fa-trash-alt"></i></button>
                        </td>
                        
                        </tr>

                    <?php endforeach ?>
                                            
                    </tbody>
                  <tfoot>
                    <tr>
                        <th>File</th>
                        <th></th>
                    </tr>
                  </tfoot>
                </table>
              
              </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#documents-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });

    $("#auditors-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function deleteAuditDocument(id, audit_documents_id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this document?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=customers/deletedocument&audit_documents_files_id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected document as it is in use.');
              }
              else {
                window.location.replace("index.php?r=customers/viewdocuments&audit_documents_id="+audit_documents_id);
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }

</script>