<?php

use yii\helpers\Html;
use yii\helpers\Url;
use yii\widgets\DetailView;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\Customers */

$this->title = $model->name;
$this->params['breadcrumbs'][] = ['label' => 'Customers', 'url' => ['index']];
$this->params['breadcrumbs'][] = $this->title;
\yii\web\YiiAsset::register($this);
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark"><?= Html::encode($this->title) ?></h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><?= Html::a('Dashboard', ['site/index']) ?></li>
          <li class="breadcrumb-item"><?= Html::a('Manage Customers', ['index']) ?></li>
          <li class="breadcrumb-item active"><?= Html::encode($this->title) ?></li>
        </ol>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <p>
                    <?= Html::a('<i class="far fa-edit"></i> Edit', ['update', 'id' => $model->id], ['class' => 'btn btn-warning']) ?>
                    <button class="btn btn-danger" id="btnDelete" onclick="deleteCustomer(<?= Html::encode($model->id)?>);" ><i class="far fa-trash-alt"></i> Delete</button>
                    <?= Html::a('<i class="fas fa-plus"></i> Add Certificate', ['addcertificate', 'customers_id' => $model->id], ['class' => 'btn btn-success']) ?>
                    <?= Html::a('<i class="far fa-list-alt"></i> Manage Customers', ['index'], ['class' => 'btn btn-info']) ?>
                    <?= Html::a('<i class="fas fa-history"></i> History', ['viewcustomerhistory', 'customers_id' => $model->id], ['class' => 'btn btn-secondary']) ?>
                </p>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <div class="form-group mb-3">
                    <dl class="row">
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('name') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->name ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('company_email') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->company_email ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('general_phone') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->general_phone ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('head_office_address') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->head_office_address ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('site_address') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->site_address ?>
                        </dd>
                        <dt class="col-sm-3">
                            <?= $model->getAttributeLabel('joined_date') ?>
                        </dt>
                        <dd class="col-sm-9">
                            <?= $model->joined_date ?>
                        </dd>
                    </dl>
                </div>

                <div class="form-group mb-3">
                    <h5>Contact Persons:</h5>
                    <dl class="row">
                        <div class="col-sm-6">
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('first_contact') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->first_contact ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('first_contact_designation') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->first_contact_designation ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('first_contact_email') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->first_contact_email ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('first_contact_phone_1') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->first_contact_phone_1 ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('first_contact_phone_2') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->first_contact_phone_2 ?>
                            </dd>
                        </div> 
                        <div class="col-sm-6">
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('second_contact') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->second_contact ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('second_contact_designation') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->second_contact_designation ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('second_contact_email') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->second_contact_email ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('second_contact_phone_1') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->second_contact_phone_1 ?>
                            </dd>
                            <dt class="col-sm-3">
                                <?= $model->getAttributeLabel('second_contact_phone_2') ?>
                            </dt>
                            <dd class="col-sm-9">
                                <?= $model->second_contact_phone_2 ?>
                            </dd>
                        </div>
                    </dl>
                </div>
              </div>
              <!-- /.card-body -->
              <div class="card-body">
                <table id="certificates-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Certificate Category</th>
                    <th>Reference Standard</th>
                    <th>Accredited</th>
                    <th>Secondary</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($customerCertificates as $customerCertificate): ?>

                  <tr>
                    <td><?= Html::encode($customerCertificate['certification_category_name']); ?></td>
                    <td><?= Html::encode($customerCertificate['reference_standard']); ?></td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" name="accredited<?=$customerCertificate['customer_certificates_id']?>" id="accredited<?=$customerCertificate['customer_certificates_id']?>" 
                          <?= ($customerCertificate['accreditation']==1 ? 'checked' : '');?>
                        >
                    </td>
                    <td>
                        <input type="checkbox" style="margin-left:5px;" name="secondary<?=$customerCertificate['customer_certificates_id']?>" id="secondary<?=$customerCertificate['customer_certificates_id']?>" 
                          <?= ($customerCertificate['secondary']==1 ? 'checked' : '');?>
                        >
                    </td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/customers/viewcustomercertificate','customer_certificates_id' => $customerCertificate['customer_certificates_id']], ['class' => 'btn btn-info']) ?>
                      <button class="btn btn-danger" id="btnDeleteCustomerCertificate<?= Html::encode($customerCertificate['customer_certificates_id'])?>" onclick="btnDeleteCustomerCertificate(<?= Html::encode($customerCertificate['customer_certificates_id'])?>,<?= Html::encode($model->id)?>);" ><i class="far fa-trash-alt"></i></button>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Certificate Category</th>
                    <th>Reference Standard</th>
                    <th>Accredited</th>
                    <th>Secondary</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
        </div>
        <!-- /.card -->
    </div>
    <!-- /.col -->
</div>


<script>
function deleteCustomer(id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this customer?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=customers/delete&id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected customer as it is in use.');
              }
              else {
                window.location.replace("index.php?r=customers");
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }

  function btnDeleteCustomerCertificate(id, customers_id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this customer certificate?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=customers/deletecustomercertificate&customer_certificates_id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected customer certificate as it is in use.');
              }
              else {
                window.location.replace("index.php?r=customers/view&id="+customers_id);
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
  </script>