<?php

use yii\helpers\Html;
use yii\widgets\ActiveForm;
use yii\helpers\ArrayHelper;
use common\models\Certificates;
use kartik\date\DatePicker;
use kartik\file\FileInput;

/* @var $this yii\web\View */
/* @var $model common\models\CustomerCertificates */
/* @var $form yii\widgets\ActiveForm */
?>

<div class="customer-certificates-form">

    <?php $form = ActiveForm::begin(); ?>

    <?= $form->field($model, 'document_types_id')->hiddenInput()->label(false); ?>
    <?= $form->field($model->documentTypes, 'name')->textInput(['maxlength' => true,'readonly'=> true]) ?>

    <?php if($model->file_name) { ?>
        <?= $form->field($model, 'file_name')->widget(FileInput::classname(), [
        'options' => ['accept' => '*.*'],'pluginOptions' => [
            'showUpload' => false, 'browseOnZoneClick' => true,
            'initialPreviewAsData' => true, 'uploadAsync' => true,
            'allowedFileExtensions' => ["jpg", "png", "gif", "pdf", "doc", "docx", "xls", "xlsx", "pdf"],
            'initialPreview' => [Url::base('') .'/uploads/audit_documents/'.$model->file_name]]]); ?>
    <?php } else { ?>
        <?= $form->field($model, 'file_name')->widget(FileInput::classname(), [
        'options' => ['accept' => '*.*'],'pluginOptions' => [
            'showUpload' => false, 'browseOnZoneClick' => true,
            'initialPreviewAsData' => true, 'uploadAsync' => true,
            'allowedFileExtensions' => ["jpg", "png", "gif", "pdf", "doc", "docx", "xls", "xlsx"]]]); ?>
    <?php } ?>


    <?= $form->field($model, 'issue_no')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'issue_date')->widget(
        DatePicker::className(),[
            'name' => 'issue_date',
            'type' => DatePicker::TYPE_COMPONENT_APPEND,
            'pluginOptions' => [
                'autoclose'=>true,
                'format' => 'yyyy-mm-dd'
            ]
        ]
    );?>

    <?= $form->field($model, 'revision_no')->textInput(['maxlength' => true]) ?>

    <?= $form->field($model, 'revision_date')->widget(
        DatePicker::className(),[
            'name' => 'revision_date',
            'type' => DatePicker::TYPE_COMPONENT_APPEND,
            'pluginOptions' => [
                'autoclose'=>true,
                'format' => 'yyyy-mm-dd'
            ]
        ]
    );?>

    <div class="form-group">
        <?= Html::submitButton('Save', ['class' => 'btn btn-success']) ?>
    </div>

    <?php ActiveForm::end(); ?>

</div>
