<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;
use kartik\dialog\Dialog;

echo Dialog::widget([
  'libName' => 'krajeeDialog',
  'options' => ['draggable' => true, 'closable' => true], 
]);

/* @var $this yii\web\View */
/* @var $model common\models\CertificateTypes */

$this->title = 'Manage Industries';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Industries</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Industries</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New Industry', ['/industries/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage industries</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="industries-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Industry</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $industry): ?>

                  <tr>
                    <td><?= Html::encode($industry->industry_name); ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/industries/view','id' => $industry->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/industries/update','id' => $industry->id], ['class' => 'btn btn-warning']) ?>
                      <button class="btn btn-danger" id="btnDelete<?= Html::encode($industry->id)?>" onclick="deleteIndustry(<?= Html::encode($industry->id)?>);" ><i class="far fa-trash-alt"></i></button>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Industry</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#industries-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });

  function deleteIndustry(id) {
    // JS Code
    krajeeDialog.confirm("Are you sure you want to delete this industry?", function (result) {
        if (result) { // ok button was pressed
          $.ajax({
            url:'index.php?r=industries/delete&id='+id,
            method:'post',
            dataType:'json',
            success:function(data){
              if(data==0) {
                krajeeDialog.alert('Unable to delete the selected industry as it is in use.');
              }
              else {
                window.location.replace("index.php?r=industries");
              }
            }
          });

        } else { // confirmation was cancelled
          return;
        }
    });
  }
</script>