<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\Phases */

$this->title = 'Manage Phases';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Phases</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Phases</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New Phase', ['/phases/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage phases</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="phases-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Phase</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $phase): ?>

                  <tr>
                    <td><?= Html::encode($phase->name); ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/phases/view','id' => $phase->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/phases/update','id' => $phase->id], ['class' => 'btn btn-warning']) ?>
                      <?= Html::a('<i class="far fa-trash-alt"></i>', ['/phases/delete','id' => $phase->id], ['class' => 'btn btn-danger']) ?>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Phase</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#phases-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>