<?php

use yii\helpers\Html;
use yii\grid\GridView;
use yii\widgets\Pjax;

/* @var $this yii\web\View */
/* @var $model common\models\Cycles */

$this->title = 'Manage Users';
$this->params['breadcrumbs'][] = $this->title;
?>

<!-- Content Header (Page header) -->
<div class="content-header">
  <div class="container-fluid">
    <div class="row mb-2">
      <div class="col-sm-6">
        <h1 class="m-0 text-dark">Manage Users</h1>
      </div><!-- /.col -->
      <div class="col-sm-6">
        <ol class="breadcrumb float-sm-right">
          <li class="breadcrumb-item"><a href="#">Dashboard</a></li>
          <li class="breadcrumb-item active">Manage Users</li>
        </ol>
        <?= Html::a('<i class="fas fa-plus"></i> New User', ['/user/create'], ['class' => 'btn btn-primary float-sm-right mr-5']) ?>
      </div><!-- /.col -->
    </div><!-- /.row -->
  </div><!-- /.container-fluid -->
</div>
<!-- /.content-header -->

<div class="row">
    <div class="col-md-12">
        <div class="card">
              <div class="card-header">
                <h3 class="card-title">Manage users</h3>
              </div>
              <!-- /.card-header -->
              <div class="card-body">
                <table id="users-table" class="table table-bordered table-striped">
                  <thead>
                  <tr>
                    <th>Username</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>User Role</th>
                    <th>Approver</th>
                    <th></th>
                  </tr>
                  </thead>
                  <tbody>

                  <?php foreach($dataProvider->getModels() as $user): ?>

                  <tr>
                    <td><?= Html::encode($user->username); ?></td>
                    <td><?= Html::encode($user->first_name); ?></td>
                    <td><?= Html::encode($user->last_name); ?></td>
                    <td><?= Html::encode($user->email); ?></td>
                    <td><?= Html::encode($user->userRole->role_name); ?></td>
                    <td><?= Html::encode($user->is_approver) == 1  ? 'Yes' : 'No'; ?></td>
                    <td>
                      <?= Html::a('<i class="far fa-eye"></i>', ['/user/view','id' => $user->id], ['class' => 'btn btn-info']) ?>
                      <?= Html::a('<i class="far fa-edit"></i>', ['/user/update','id' => $user->id], ['class' => 'btn btn-warning']) ?>
                      <?= Html::a('<i class="far fa-trash-alt"></i>', ['/user/delete','id' => $user->id], ['class' => 'btn btn-danger']) ?>
                    </td>
                  </tr>

                  <?php endforeach ?>
                  
                  </tbody>
                  <tfoot>
                  <tr>
                    <th>Username</th>
                    <th>First Name</th>
                    <th>Last Name</th>
                    <th>Email</th>
                    <th>User Role</th>
                    <th>Approver</th>
                    <th></th>
                  </tr>
                  </tfoot>
                </table>
              </div>
              <!-- /.card-body -->
            </div>
            <!-- /.card -->
    </div>
    <!-- /.col -->
</div>

<script>
  $(function () {
    $("#users-table").DataTable({
      "responsive": true,
      "autoWidth": false,
    });
  });
</script>